<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
  // 引用 head.inc
  include_once "html_head.inc";
  ?>
</head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    // include_once "html_menu.inc";
    include_once "html_layout_header.inc";
    ?>
    <!-- 內容區域 //-->
    <data-table :show-search-field="true" :show-search-panel="true" :columns="columns" :data="tableData" row-key="no" @search-ok="searsh_list()">
      <template v-slot:page-sticky>
        <!-- <q-btn round color="primary" @click="console.log(list)" icon="info"></q-btn> -->
      </template>
      <template v-slot:search-panel-actions>

      </template>
      <template v-slot:search-form>
        <div>
          <div class="w3-row-padding">
            <div class="w3-col l4 s6" style="max-width:300px">
              <q-select v-model="search.store" :stack-label="$t('page.cashier_manage.search.store')" :options="store" filter />
            </div>
          </div>
        </div>
      </template>
      <template v-slot:row-control="props">
        <q-btn v-if="setting_cheak" color="primary" :label="$t('sys.setting')" @click.native="open_cashier_info('edit',props.row_data.row)"></q-btn>
      </template>
    </data-table>
    <!-- /內容區域 //-->


    <template>
      <q-modal v-model="cashier_info['show']" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss :content-css="{minWidth: '10vw', maxHeight: '100vh'}">
        <div class="modal-title">
          <div v-if="cashier_info['show_add_btn']">
            {{ $t('page.cashier_manage.cashier_info_block.add_title') }}
          </div>
          <div v-else="">
            {{ $t('page.cashier_manage.cashier_info_block.edit_title') }}
          </div>
        </div>
        <div class="modal-scroll-box" style="padding:15px; font-weight: 700; font-size:16px">
          <div style="margin-top: 0px;">
            <label style="color:#979797;" v-text="$t('page.cashier_manage.cashier_info_block.cashier_name')"></label>
            <q-input v-model="cashier_info['cashier_name']"></q-input>
          </div>
        </div>
        <div style="display:flex; flex-grow: row; justify-content: center;margin: 20px;">
          <q-btn color="primary" :label="$t('sys.update')" class="btn-style2" @click="save_cashier_info()" v-if="cashier_info['show_edit_btn']"></q-btn>
          <q-btn :color="cashier_info['show_edit_btn'] == true ? 'secondary' : 'secondary'" :label="$t('sys.close')" class="btn-style2" @click="cancel_cashier_info()"></q-btn>
        </div>
      </q-modal>
    </template>
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  // loading.inc
  include_once "html_loading.inc";
  ?>
</body>
<?php
$is_report_download = true;
// 引用 down.inc
include_once "html_down.php";
?>

</html>