var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_received_statement_list",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      date_type: [
        { label: "營業日", value: 1 },
        { label: "收款日", value: 2 }
      ],
      search: {
        store: "1",
        date_type: 1, //查詢時間區間類型 1:營業日 2:收款日
        start_date: moment().format("YYYY/MM/DD"),
        end_date: moment().format("YYYY/MM/DD"),
      },
      excel_name: "StoreCollectionDetail",
    };
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "received_date",
          required: true,
          label: this.$t(
            "page.store_received_statement_list.columns.received_date"
          ),
          align: "left",
          field: "received_date",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = "";
            if (data != null) {
              dt = moment(data).format("YYYY-MM-DD");
            }
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 0,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "business_date",
          required: true,
          label: this.$t(
            "page.store_received_statement_list.columns.business_date"
          ),
          align: "left",
          field: "business_date",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = "";
            if (data != null) {
              dt = moment(data).format("YYYY-MM-DD");
            }
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 1,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_id",
          required: true,
          label: this.$t("page.store_received_statement_list.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 2,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_name",
          required: true,
          label: this.$t(
            "page.store_received_statement_list.columns.store_name"
          ),
          align: "left",
          field: "store_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 3,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "received_ledger_id",
          required: true,
          label: this.$t(
            "page.store_received_statement_list.columns.received_ledger_id"
          ),
          align: "left",
          field: "received_ledger_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 4,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "logistics_amount",
          required: true,
          label: this.$t(
            "page.store_received_statement_list.columns.logistics_amount"
          ),
          align: "left",
          field: "logistics_amount",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 5,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "commodity_amount",
          required: true,
          label: this.$t(
            "page.store_received_statement_list.columns.commodity_amount"
          ),
          align: "left",
          field: "commodity_amount",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 6,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_amount",
          required: true,
          label: this.$t(
            "page.store_received_statement_list.columns.total_amount"
          ),
          align: "left",
          field: "total_amount",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 7,
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //excel 報表匯出 名稱定義
    excel_name_str() {
      let res = "";
      let store = "";
      let that = this;
      if (this.search.store != 0) {
        this.store.forEach(el => {
          if (el.value == that.search.store) {
            store = `_${el.label}`;
          }
        });
      }
      res = `${this.excel_name}ExportExcel${store}`;
      return res;
    }
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      var params = {
        Action: "ReceivedInfoList",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
