<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{

	public function SelectRoles($params)
	{

		$sql = sprintf(
			"SELECT * 
						FROM [%s].[dbo].[roles]
						WHERE [role_ui_hide] = 0 AND [is_ui_visible] = 1",
			$this->database_trend
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([]);
		return $sth->fetchAll(PDO::FETCH_ASSOC);
	}

	//	抓角色之前頁面紀錄
	public function SelectMenu($params)
	{

		$res = [];
		$sql = sprintf(
			"SELECT 
				[menu_id],
				[function_list]
			FROM 
				[%s].[dbo].[roles_menu]
			WHERE 
				[role_id] = :role_id;",
			$this->database_trend
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			'role_id' => $params['role_id'],
		]);
		$row =  $sth->fetchAll(PDO::FETCH_ASSOC);

		foreach ($row as $k => $v) {
			$res[] = $v["menu_id"];
			if (!empty($v["function_list"])) {
				foreach (explode(",", $v["function_list"]) as $func_k => $func_v) {
					$res[] = $v["menu_id"] . "." . $func_v;
				}
			}
		}
		return $res;
	}

	//	新增，更新 [roles_menu]
	public function ChangeRoleMenu($params)
	{
		try {

			$this->pdo_sql->beginTransaction();

			//	查詢[roles_menu]有沒有紀錄
			$sql = sprintf(
				"SELECT *
							FROM [%s].[dbo].[roles_menu] 
							WHERE [role_id] = :role_id;",
				$this->database_trend
			);
			$sth = $this->pdo_sql->prepare($sql);
			$sth->execute([
				'role_id' => $params['role'],
			]);

			if ($sth->fetch(PDO::FETCH_BOUND) == 1) {
				$sql = sprintf(
					"DELETE 
								FROM [%s].[dbo].[roles_menu] 
								WHERE [role_id] = :role_id;",
					$this->database_trend
				);
				$sth = $this->pdo_sql->prepare($sql);
				$sth->execute([
					'role_id' => $params['role'],
				]);
				if ($sth->rowCount() == 0) {
					throw new Exception("roles_menu刪除失敗");
				}
			} else {
			}


			//先整理寫入頁面資訊
			$a_insert_roles_menu = [];
			foreach ($params['page_arr'] as  $page_name) {
				//判斷page_name 是否有含. 韓.代表為.符號前字段所對應的頁面內的功能權限設定，需寫入roles_menu表內的function_list(以字串儲存)
				if (strpos($page_name, ".") !== false) {
					//依據.符號拆解出function_name 例如 store_commodity_order.search 會拆成 store_commodity_order跟search
					$a_page_func = explode(".", $page_name);
					$s_menu_id = $a_page_func[0];
					$s_menu_func = $a_page_func[1];
					$a_insert_roles_menu[$s_menu_id]["function_list"][] = $s_menu_func;
				} else {
					$a_insert_roles_menu[$page_name]["menu_id"] = $page_name;
				}
			}
			foreach ($a_insert_roles_menu as $k => $v) {
				$s_function_list = empty($v["function_list"]) ? "" : implode(",", $v["function_list"]);
				$sql = sprintf("INSERT INTO [%s].[dbo].[roles_menu] (
									 [role_id]
		      						,[menu_id]
		      						,[function_list]
								) VALUES (
									 :role_id
									,:page_id
									,:function_list
								);", $this->database_trend);
				$sth = $this->pdo_sql->prepare($sql);
				$sth->execute([
					'role_id' => $params['role'],
					'page_id' => $v["menu_id"],
					'function_list' => $s_function_list
				]);

				if ($sth->rowCount() == 0) {
					throw new Exception("roles_menu資料表建立失敗");
				}
			}


			$this->pdo_sql->commit();
			return true;
		} catch (Exception $mes) {
			$this->pdo_sql->rollBack();
			return $mes->getMessage();
		}
	}
	//更新 角色門市顯示設定
	public function Changerole_store_view($params)
	{
		$b_store_view_check = (bool) $params["store_view"];
		$n_store_ctrl = $b_store_view_check ? 0 : 1;
		$s_role_id = (string) $params["role"];
		$sql = sprintf(
			"UPDATE 
				[%s].[dbo].[roles] 
			SET 
				[store_ctrl] = :store_ctrl
			WHERE
				[role_id] = :role_id;",
			$this->database_trend
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			'store_ctrl' => $n_store_ctrl,
			'role_id' => $s_role_id
		]);



		return "ok";
	}
}
