<?php
/* 各API 需有 token_verify() token驗證function ，因各API撈取API金鑰方式不同*/
class WebAPIForMenuPage extends base_class
{


    /**
     * Leo
     * 新增補鈔資料
     */
    public function Create_currency_replenish($params)
    {
        //設定寫入資料
        $s_cashier_id = (string) $params["cashier"];
        $s_create_at = (string) $params["create_at"];
        //循環箱 補入
        // $n_cycle_box_500 = (int) $params["replenish_500"];  //2024/03/12 調整為寫入LCDM出鈔機 
        // $n_cycle_box_100 = (int) $params["replenish_100"];  //2024/03/12 調整為寫入LCDM出鈔機 
        //LCDM 出鈔機補入 (通常為備用)
        $n_sub_replenish_500 = (int) $params["replenish_500"]; //2024/03/12 replenish_500 調整為寫入LCDM出鈔機 
        $n_sub_replenish_100 = (int) $params["replenish_100"]; //2024/03/12 replenish_100 調整為寫入LCDM出鈔機 

        $n_cycle_box_50 = (int) $params["replenish_50"];
        $n_cycle_box_10 = (int) $params["replenish_10"];
        $n_cycle_box_5 = (int) $params["replenish_5"];
        $n_cycle_box_1 = (int) $params["replenish_1"];

        $n_operate_type = 2; //操作類型 1.溢幣 2. 純補入 3.換補(收款) 4.無交易貨幣異動(機台測試或其他操作)

        //先查詢門市資訊
        $sql = sprintf(
            "SELECT 
                    _c.store_id
			FROM 	
				[%s].[dbo].[cashier] AS _c 
			WHERE
                _c.cashier_id = :cashier_id
			",
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "cashier_id" => $s_cashier_id
        ]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        if (empty($row)) { // 門市存在與否判斷
            throw new Exception("store 異常", 20);
        }
        $n_store_id = $row["store_id"];

        //設定寫入資料
        $a_insert_arr = [
            "cashier_id" => $s_cashier_id,
            "store_id" => $n_store_id,
            "create_at" => $s_create_at,
            "cycle_box_50" => $n_cycle_box_50,
            "cycle_box_10" => $n_cycle_box_10,
            "cycle_box_5" => $n_cycle_box_5,
            "cycle_box_1" => $n_cycle_box_1,
            "sub_500_out" => $n_sub_replenish_500,
            "sub_100_out" => $n_sub_replenish_100,
            "operate_type" => $n_operate_type,
        ];
        //拼接sql字串
        $sql = sprintf(
            "INSERT INTO [%s].[dbo].[cashier_currency_statement](
                cashier_id,
                store_id,
                create_at,
                cycle_box_50,
                cycle_box_10,
                cycle_box_5,
                cycle_box_1,
                sub_500_out,
                sub_100_out,
                operate_type
            )
            VALUES
            (
                :cashier_id,
                :store_id,
                :create_at,
                :cycle_box_50,
                :cycle_box_10,
                :cycle_box_5,
                :cycle_box_1,
                :sub_500_out,
                :sub_100_out,
                :operate_type
            )
			",
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute($a_insert_arr);

        return "OK";
    }
    /**
     * Leo
     * api 驗證
     */
    public function api_verify($token, $params)
    {
        //門市編號
        $n_store_id = (int) $params["store"];
        if ($n_store_id == 0) { //門市編號為空
            throw new Exception("store 欄位不可為空", 91000);
        } else {    //檢查門市是否存在
            $sql = sprintf(
                "SELECT 
                        _s.store_id
                FROM 	
                    [%s].[dbo].[store] AS _s 
                WHERE
                    _s.store_id = :store_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "store_id" => $n_store_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("store 異常", 91000);
            }
        }
        //機台序號
        $s_cashier_id = (string) $params["cashier"];
        if ($s_cashier_id == "") { //機台編號為空
            throw new Exception("cashier 欄位不可為空", 91000);
        } else { //檢查機台是否存在
            $sql = sprintf(
                "SELECT 
                        _c.cashier_id
                FROM 	
                    [%s].[dbo].[cashier] AS _c
                WHERE
                    _c.cashier_id = :cashier_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "cashier_id" => $s_cashier_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("cashier error", 91000);
            }
        }
        //時間戳(單位秒)
        $s_send_at = (string) $params["send_at"];
        if ($s_send_at == "") { //時間戳為空
            throw new Exception("send_at 欄位不可為空", 91000);
        } else if ($this->check_timestamp_format($s_send_at) != true) {
            throw new Exception("send_at format error", 91000);
        }
        //Token
        if (trim($token) == "") { //Token為空
            throw new Exception("token 欄位不可為空", 91000);
        }
        //循環機 補入數量-500 2024/03/12 調整為寫入LCDM出鈔機 
        $n_replenish_500 = (int) $params["replenish_500"];
        if (!isset($params["replenish_500"])) { // SCR循環機 補入數量-500為空
            throw new Exception("replenish_500 欄位不可為空", 91000);
        } else if ($n_replenish_500 < 0) {
            throw new Exception("replenish_500 不可為負數");
        }
        //循環機 補入數量-100 2024/03/12 調整為寫入LCDM出鈔機 
        $n_replenish_100 = (int) $params["replenish_100"];
        if (!isset($params["replenish_100"])) { // SCR循環機 補入數量-100為空
            throw new Exception("replenish_100 欄位不可為空", 91000);
        } else if ($n_replenish_100 < 0) {
            throw new Exception("replenish_100 不可為負數");
        }
        //硬幣機 補入數量-50
        $n_replenish_50 = (int) $params["replenish_50"];
        if (!isset($params["replenish_50"])) { // 硬幣機 補入數量-50為空
            throw new Exception("replenish_50 欄位不可為空", 91000);
        } else if ($n_replenish_50 < 0) {
            throw new Exception("replenish_50 不可為負數");
        }
        //硬幣機 補入數量-10
        $n_replenish_10 = (int) $params["replenish_10"];
        if (!isset($params["replenish_10"])) { // 硬幣機 補入數量-10為空
            throw new Exception("replenish_10 欄位不可為空", 91000);
        } else if ($n_replenish_10 < 0) {
            throw new Exception("replenish_10 不可為負數");
        }
        //硬幣機 補入數量-5
        $n_replenish_5 = (int) $params["replenish_5"];
        if (!isset($params["replenish_5"])) { // 硬幣機 補入數量-5為空
            throw new Exception("replenish_5 欄位不可為空", 91000);
        } else if ($n_replenish_5 < 0) {
            throw new Exception("replenish_5 不可為負數");
        }
        //硬幣機 補入數量-1
        $n_replenish_1 = (int) $params["replenish_1"];
        if (!isset($params["replenish_1"])) { // 硬幣機 補入數量-1為空
            throw new Exception("replenish_1 欄位不可為空", 91000);
        } else if ($n_replenish_1 < 0) {
            throw new Exception("replenish_1 不可為負數");
        }

        // //LCDM出鈔機 補入數量-500
        // $n_replenish_500 = (int) $params["sub_replenish_500"];
        // if (!isset($params["sub_replenish_500"])) { // LCDM出鈔機 補入數量-500為空
        //     throw new Exception("sub_replenish_500 欄位不可為空", 91000);
        // } else if ($n_replenish_500 < 0) {
        //     throw new Exception("sub_replenish_500 不可為負數");
        // }
        // //LCDM出鈔機 補入數量-100
        // $n_replenish_100 = (int) $params["sub_replenish_100"];
        // if (!isset($params["sub_replenish_100"])) { // LCDM出鈔機 補入數量-100為空
        //     throw new Exception("sub_replenish_100 欄位不可為空", 91000);
        // } else if ($n_replenish_100 < 0) {
        //     throw new Exception("sub_replenish_100 不可為負數");
        // }
        //建立時間
        $s_create_at = (string) $params["create_at"];
        if ($s_create_at == "") { // 建立時間為空
            throw new Exception("create_at 欄位不可為空", 91000);
        } else if ($this->check_date_format($s_create_at) != true) { //時間格式不正確
            throw new Exception("create_at 時間格式不正確", 91000);
        }


        //依據資料查詢門市API金鑰來進行Token驗證
        $sql = sprintf(
            "SELECT 
                    _s.store_api_key,
                    _c.cashier_id
            FROM 	
                 [%s].[dbo].[cashier] AS _c
                 LEFT JOIN [%s].[dbo].[store] AS _s ON _s.store_id = _c.store_id
            WHERE
                _c.store_id = :store_id AND
                _c.cashier_id = :cashier_id",
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "store_id" => $n_store_id,
            "cashier_id" => $s_cashier_id
        ]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        if (!empty($row)) {
            $s_api_key = $row["store_api_key"];
            if ($this->shopee_api_token_verify($token, $s_api_key, $s_send_at) != true) {
                throw new Exception("Token Verification Failed", 91001);
            }
        } else {
            //查詢不到該門市該機台
            throw new Exception("store and cashier not binding", 91000);
        }
        //更新最後連線時間
        $this->cashier_connect_time_update($n_store_id, $s_cashier_id, $s_send_at);
    }
}
