<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
      // 引用 head.inc
      include_once "html_head.inc";
      ?></head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    // include_once "html_menu.inc";
    include_once "html_layout_header.inc";
    ?>
    <!-- 內容區域 //-->
    <data-table :show-search-field="true" :show-search-btn="false" :show-search-panel="false" :title="$t('menu.admin_users')" :columns="columns" :data="tableData" row-key="name" @search-ok="searchOk">

      <template v-slot:page-sticky v-if="add_cheak">
        <q-btn round color="primary" @click="addUser()" icon="add"></q-btn>
      </template>

      <template v-slot:row-control="props" v-if="edit_cheak">
        <q-btn color="primary" :label="$t('sys.edit')" @click.native="editUser(props.row_data)"></q-btn>
      </template>

      <template v-slot:row_col_status="props"><button>status</button>{{props.row_data.row}}</template>
      <template v-slot:row_col_calories="props"><button>calories</button>{{props.row_data.row}}</template>
    </data-table>

    <template>
      <q-modal v-model="addUserInfo['show']" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss :content-css="{minWidth: '40vw', maxHeight: '100vh'}">

        <div class="modal-title">
          <div v-if="addUserInfo['editUserDisable']">
            {{ $t('menu.admin_users') }}{{ $t('page.admin_users.edit') }}
          </div>
          <div v-else>
            {{ $t('menu.admin_users') }}{{ $t('page.admin_users.add') }}
          </div>
        </div>
        <div class="modal-scroll-box" style="padding:15px; font-weight: 700; font-size:16px">

          <div style="margin-top: 0px;">
            <label style="color:#979797;" v-text="$t('page.admin_users.columns.user_id') +' '"></label><a style="color:red">＊</a>
            <q-input v-model="addUserInfo['userID']" :disable="addUserInfo['editUserDisable']"></q-input>
          </div>

          <div style="margin-top: 15px;">
            <label style="color:#979797;" v-text="addUserInfo['showEditBtn'] == true ? $t('page.admin_users.columns.password2') : $t('page.admin_users.columns.password')"></label><a style="color:red" v-text="addUserInfo['showEditBtn'] == true ? '':'＊'"></a>
            <q-input v-model="addUserInfo['password']" type="password"></q-input>
          </div>

          <div style="margin-top: 15px;">
            <label style="color:#979797;" v-text="addUserInfo['showEditBtn'] == true ? $t('page.admin_users.columns.password3') : $t('page.admin_users.columns.password1')"></label><a style="color:red" v-text="addUserInfo['showEditBtn'] == true ? '':'＊'"></a>
            <q-input v-model="addUserInfo['checkPassword']" type="password"></q-input>
          </div>

          <div style="margin-top: 15px;">
            <label style="color:#979797;" v-text="$t('page.admin_users.columns.name')"></label><a style="color:red">＊</a>
            <q-input v-model="addUserInfo['name']"></q-input>
          </div>

          <div style="margin-top: 15px;">
            <label style="color:#979797;" v-text="$t('page.admin_users.columns.role')"></label><a style="color:red">＊</a>
            <q-select filter :multiple="addUserInfo['multiple']" v-model="addUserInfo['role']['value']" :options="addUserInfo['role']['options']"></q-select>
          </div>
        </div>

        <div style="display: flex; flex-flow: row wrap; justify-content: flex-end; align-items: center;margin-right: 20px;font-size:14px">
          <a>(</a>
          <a style="color:red">＊</a>
          <a>)</a>
          <a>&nbsp{{ $t('page.admin_users.RI') }}</a>
        </div>

        <div style="display:flex; flex-grow: row; justify-content: center;margin: 20px;">
          <q-btn color="primary" :label="$t('sys.save')" class="btn-style2" @click="saveAddUser()" v-if="addUserInfo['showAddBtn']"></q-btn>
          <q-btn color="primary" :label="$t('sys.update')" class="btn-style2" @click="saveEditUser()" v-if="addUserInfo['showEditBtn']"></q-btn>
          <q-btn color="negative" :label="$t('sys.delete')" class="btn-style2" @click="deleteUser()" v-if="addUserInfo['showDeleteBtn']"></q-btn>
          <q-btn :color="addUserInfo['showEditBtn'] == true ? 'secondary' : 'secondary'" :label="$t('sys.close')" class="btn-style2" @click="cancelAddUser()"></q-btn>

        </div>


      </q-modal>
    </template>







    <!-- /內容區域 //-->
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  // loading.inc
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_report_download = true;
        // 引用 down.inc
        include_once "html_down.php";
        ?>

</html>