/*
  FILE: i18n_messages.js
  在 html_down.php 引入
  usage:
    <div>{{ $t("lbl.hello") }}</div>
    this.$t("lbl.hello")
*/
if ($$i18n_messages == undefined) {
  var $$i18n_messages = {}
}
$$i18n_messages["en-us"] = { // en-us 英語
  "language": "English",
  "sys": {
    "version": "version",
    "loading_wait": "loading data, please wait",
    "plz_try_again": "please try again",
    "user": "user",
    "ok": "ok",
    "cancel": "cancel",
    "edit": "edit",
    "view": "view",
    "export": "export",
    "search": "search",
    "setting": "setting",
    "save": "save",
    "update": "update",
    "delete": "delete",
    "void": "void",
    "close": "close",
    "recovery": "recovery",
    "default": "default",
    "column": "column",
    "retaliation" : "retaliation",
    "record" : "record",
    "phase": {
      "draft": "Draft",
      "execute": "Execute",
      "complete": "Complete",
      "end": "End",
      "cancel": "Cancel",
      "void": "Void",
    },
    "message": {
      "info": "info",
      "confirm": "confirm",
      "download_error": "download error",
      "are_sure_to_execute": "are you sure to execute?",
      "execute_success": "execute success",
    },
    "weather_location": { // 可再此加其它縣市
      "city": {
        "彰化縣": "Zhanghua",
        "臺南市": "Tainan",
        "臺中市": "Taichung",
      },
      "town": {
        "伸港鄉": "Shengang",
        "仁德區": "Rende",
        "大里區": "Dali",
        "社頭鄉": "Shetou",
        "秀水鄉": "Xiushui",
        "永康區": "Yongkang",
      },

    },
  },
  "options": {
    "time": {
      "all_time": "All Time",
      "ten_min": "10 Minute",
      "thirty_min": "30 Minute",
      "one_hour": "1 Hour",
      "one_day": "1 Day",
    },
  },
  "layout": {
    "system_name": "Solar System",
    "menu": "menu",
    "collapse_menu": "collapse menu",
    "expand_menu": "expand menu",
    "right_menu": "right menu",
    "right_menu_msg":{
      "select": "Case switched 案場",
      "noselect": "you choose ",
      "nocctv":" no CCTV",
    },
    "nav_menu": {
      "home": "home",
      "station_list": "station list",
      "back": "back",
    },
    "change_password": {
      "title": "change password",
      "label": {
        "user_id": "user id",
        "user_name": "user name",
        "old_pwd": "old password",
        "new_pwd1": "new password",
        "new_pwd2": "confirm new password",
      },
      "msg": {
        "new_pwd_empty": "new password can not be empty",
        "new_pwd_not_same": "new password and confirm new password are not the same",
        "old_pwd_error": "old password error",
        "other_error": "other error",
        "change_pwd_success": "change password success",
      },
    },
  },
  "page": {
    "login": {
      "system_login": "System Login",
      "account": "user id",
      "password": "password",
      "login": "login",
      "logout": "logout",
      "plz_login_again": "please login again",
      "login_expire": "login expired",
      "login_failed": "login failed",
      "verify_failed": "verification failed",
    },
    "index": {
      "ac_power": "AC Power",
      "pyanometer": "Pyranometer(Avg)",
      "site_title_info": {
        "project_name": "Project Name",
        "location": "Location",
        "installed_capacity": "Installed Capacity ",
        "system_running_date": "System Running Date",
        "numbers_of_station": "Numbers of Station",
        "system_status": "System Status",
      },
      "month_power_trend": {
        "today_power_generation": "Today Power Generation",
        "pr_value": "PR Value",
        "monthly_power_generation": "Monthly Power Generation",
      },
      "weather_info": {
        "title": {
          "weather": "Weather Report"
        },
        "pyranometer": "Pyranometer(H)",
        "rain_gauge": "Rain Gauge",
        "ambient_temperature": "Ambient Temperature",
        "ambient_humidity": "Ambient Humidity",
        "wind_speed": "Wind Speed",
        "wind_direction": "Wind Direction",
        "weather_short": {
          "clear": "Clear",
          "cloudy": "Cloudy",
          "thunderstorm": "Thunderstorm",
          "cloudy_fog": "Cloudy Fog",
          "fog": "Fog",
          "snowing": "Snowing",
        },
      },
      "all_ac_station_info": {
        "energy": "Energy (MWh)：",
        "total_power": "Total Power：",
        "ambient_temperature": "Ambient Temperature：",
        "pyranometer": "Pyranometer(Tilt Angle)：",
        "status": "Status：",
        "ac_power": "AC POWER：",
        "dc_power": "DC POWER：",
      },
    },
    "stn_index": {
      "site_title_info": {
        "capacity": "Installed Capacity：",
        "name": "Station Name：",
        "stutas": "System Status：",
      },
      "environmental_sensor_chart": {
        "air_temp": "Temperature(°C)",
        "air_temp2": "Ambient Temperature",
        "pv_model_temp": "PV Module Temperature(°C)",
        "pv_model_temp2": "PV Module Temperature",
        "sunshine_lux": "TiltAngle(W/m2)",
        "sunshine_lux2": "Pyranometer(Tilt Angle)",
      },
    },
    "hv_room": {
      "title": "HV ROOM",
      "start_date": "Start Date",
      "end_date": "End Date",
      "time_interval": "Time Interval",
      "columns": {
        "time_stamp": "DateTime",
        "ac_power": "AC Power (kW)",
        "dc_power": "DC Power (kW)",
        "pyranometer_h": "Pyranometer(H)",
        "pyranometer_ta": "Pyranometer(Tilt angle)",
        "today_m_wh": "Today MWh",
        "total_m_wh": "Total MWh",
      },
    },
    "station_list": {
      "ac_station_status": "AC Station List",
      "columns": {
        "no": "No",
        "ac_station": "AC Station",
        "status": "Status",
        "installed_capacity": "Installed Capacity (MW)",
        "Time_Stamp" : "Update",
        "today_kwh" : "Today's Power (kWh)",
        "total_kwh" : "Total Power (kWh)",
        "temp" : "Temperature (°C)",
        "sunshine" : "Pyranometer (W/m2)",
        "ac_all_power" : "AC Power (P)",
        "ac_all_current" : "AC Current (I)",
        "ac_avg_voltage" : "AC Voltage (V)",
        "dc_all_power" : "DC Power (P)",
        "dc_all_current" : "DC Current (I)",
        "dc_avg_voltage" : "DC Voltage (V)",
      },
    },
    "alarm_list": {
      "alarm_list": "Alarm List",
      "search": {
        "start_date": "Start Date",
        "end_date": "End Date",
        "location": "Location",
        "alarm_priority": "Alarm Priority",
        "equipment": "Equipment",
        "not_returning": "Not Returning",
      },
      "columns": {
        "no": "No",
        "location": "Location",
        "equipment": "Equipment",
        "alarm_time": "Alarm Time",
        "recovery_time": "Recovery Time",
        "comfirm_time": "Comfirm Time",
        "message": "Message",
        "alarm_priority": "Alarm Priority",
        "value": "Value",
      },
    },
    "ai_alarm_list": {
      "search": {
        "start_date": "Start Date",
        "end_date": "End Date",
        "location": "Location",
        "alarm_type": "Alarm Type",
      },
      "columns": {
        "alarm_time": "Time",
        "alarm_type": "Type",
        "stn": "Station No.",
        "stn_name": "Station Name",
        "inv": "INV",
        "mppt": "MPPT",
        "message": "Message",
      },
      /*"alarm_type": {
        "inv_pr_limit_day": "Low INV-PR Alarm (Daily)",
        "inv_pr_limit_many_days": "Low INV-PR Alarm (Multiple Days)",
        "many_inv_pr_limit_day": "Low INV-PR Alarm for the Entire Site (Daily)",
        "mppt_ra_limit_day": "Low INV-MPPT RA Circuit Alarm (Daily)",
        "mppt_ra_limit_hour": "Low INV-MPPT RA Circuit Alarm (Hourly)",
        "mppt_ra_limit_many_days": "Low INV-MPPT RA Circuit Alarm (Multiple Days)",
        "solar_panel_clean": "Solar Panel Cleaning Alarm",
      }*/
    },
    "stn_data_alarm_list": {
      "search": {
        "start_date": "Start Date",
        "end_date": "End Date",
        "location": "Location",
        "alarm_type": "Alarm Type",
        "not_returning": "Not Returning",
      },
      "columns": {
        "alarm_time": "Alarm Time",
        "al_norm_time": "Recovery Time",
        "alarm_type": "Type",
        "stn": "Station No.",
        "stn_name": "Station Name",
        "message": "Message",
      },
    },
    "stn_alarm_list": {
      "alarm_list": "Alarm List",
      "search": {
        "start_date": "Start Date",
        "end_date": "End Date",
        "location": "Location",
        "alarm_priority": "Alarm Priority",
        "equipment": "Equipment",
        "not_returning": "Not Returning",
      },
      "columns": {
        "no": "No.",
        "location": "Location",
        "equipment": "Equipment",
        "alarm_time": "Alarm Time",
        "recovery_time": "Recovery Time",
        "comfirm_time": "Comfirm Time",
        "message": "Message",
        "alarm_priority": "Alarm Priority",
        "value": "Value",
      },
    },
    "alarm_list_confirm": {
      "alarm_list_confirm": "Alarm List Confirm",
      "search": {
        "start_date": "Start Date",
        "end_date": "End Date",
        "location": "Location",
        "alarm_priority": "Alarm Priority",
        "equipment": "Equipment",
        "not_check": "Not Check"
      },
      "columns": {
        "no": "No.",
        "location": "Location",
        "equipment": "Equipment",
        "alarm_time": "Alarm Time",
        "recovery_time": "Recovery Time",
        "comfirm_time": "Comfirm Time",
        "message": "Message",
        "alarm_priority": "Alarm Priority",
        "value": "Value",
      },
    },
    "alarm_dispatch": {
      "dispatch": "dispatch",
      "re_dispatch": "dispatch",
      "start_date": "Start Date",
      "end_date": "End Date",
      "phase": "Phase",
      "station": "Station",
      "form_id": "Form ID",
      "seq": "Alarm ID",
      "stn": "STN",
      "stn_name": "Station Name",
      "al_start_time": "Alarm Time",
      "al_message": "Alarm Message",
      "owner_user_name": "Owner Name",
      "assign_user_name": "Assign Name",
      "comment": "Comment",
      "form_content": "Form Content",
      "reply_content": "Reply Content",
      "reply": "Reply",
      "upload_image": "Upload Image",
      "message": {
        "please_assign": "Please assign a task assignee.",
        "confirm_dispatch": "Are you sure to dispatch?",
        "confirm_del_form": "Are you sure to delete this form?",
        "confirm_void_form": "Are you sure to void this form?",
        "confirm_complete_form": "Are you sure to complete this form?",
        "confirm_re_dispatch": "Are you sure to re-dispatch?",
        "confirm_end_form": "Are you sure to end this form?",
        "confirm_save_form": "Are you sure to save this form?",

      },
    },
    "weather_report": {
      "weather_report": "Weather Report - All AC Station",
      "location": "All AC Station",
      "location2": "",
      "location_no": "AC Station",
      "search": {
        "start_date": "Start Date",
        "end_date": "End Date",
        "location": "Location",
      },
      "columns": {
        "station_no": "Station No.",
        "date_time": "DateTime",
        "pyranometer_horizontal": "Pyranometer(Horizontal)",
        "ambient_temperature": "Ambient Temperature",
        "pyranometer_tilt_angle": "Pyranometer(Tilt Angle)",
        "ambient_humidity": "Ambient Humidity",
        "wind_direction": "Wind Direction",
        "wind_speed": "Wind Speed",
        "rain_gauge": "Rain Gauge",
      },
    },
    "weather_summary": {
      "status": "Status",
      "pyranomete": "Pyranomete",
      "ambient_temp": "Ambient Temp",
      "module_temp": "Module Temp",
      "average": "Average",
    },
    "inverter_list": {
      "inverter": "Inverter Instant Data",
      "columns": {
        "Inver_No" : "Inverter No",
        "Invert" : "Inverter Table Name",
        "Invert_Name" : "Inverter Name",
        "STN" : "Station",
        "Time_Stamp" : "Update",
        "broken_line" : "Status",
        "today_kwh" : "Today's Power",
        "total_kwh" : "Total Power",
        "ac_avg_voltage" : "AC Average Voltage",
        "ac_avg_voltage_L" : "",
        "ac_total_current" : "AC Total Current",
        "ac_total_power" : "AC Total Power",
        "ac_voltage01" : "AC_01 Voltage",
        "ac_voltage02" : "AC_02 Voltage",
        "ac_voltage03" : "AC_03 Voltage",
        "ac_voltage_L_01" : "",
        "ac_voltage_L_02" : "",
        "ac_voltage_L_03" : "",
        "ac_current01" : "AC_01 Current",
        "ac_current02" : "AC_02 Current",
        "ac_current03" : "AC_03 Current",
        "ac_power01" : "AC_01 Power",
        "ac_power02" : "AC_02 Power",
        "ac_power03" : "AC_03 Power",
        "conversion" : "Conversion",
        "dc_avg_voltage" : "DC Average Voltage",
        "dc_total_current" : "DC Total Current",
        "dc_total_power" : "DC Total Power",
        "dc_voltage01" : "DC_01 Voltage",
        "dc_voltage02" : "DC_02 Voltage",
        "dc_voltage03" : "DC_03 Voltage",
        "dc_voltage04" : "DC_04 Voltage",
        "dc_voltage05" : "DC_05 Voltage",
        "dc_voltage06" : "DC_06 Voltage",
        "dc_voltage07" : "DC_07 Voltage",
        "dc_voltage08" : "DC_08 Voltage",
        "dc_voltage09" : "DC_09 Voltage",
        "dc_voltage10" : "DC_10 Voltage",
        "dc_voltage11" : "DC_11 Voltage",
        "dc_voltage12" : "DC_12 Voltage",
        "dc_current01" : "DC_01 Current",
        "dc_current02" : "DC_02 Current",
        "dc_current03" : "DC_03 Current",
        "dc_current04" : "DC_04 Current",
        "dc_current05" : "DC_05 Current",
        "dc_current06" : "DC_06 Current",
        "dc_current07" : "DC_07 Current",
        "dc_current08" : "DC_08 Current",
        "dc_current09" : "DC_09 Current",
        "dc_current10" : "DC_10 Current",
        "dc_current11" : "DC_11 Current",
        "dc_current12" : "DC_12 Current",
        "dc_power01" : "DC_01 Power",
        "dc_power02" : "DC_02 Power",
        "dc_power03" : "DC_03 Power",
        "dc_power04" : "DC_04 Power",
        "dc_power05" : "DC_05 Power",
        "dc_power06" : "DC_06 Power",
        "dc_power07" : "DC_07 Power",
        "dc_power08" : "DC_08 Power",
        "dc_power09" : "DC_09 Power",
        "dc_power10" : "DC_10 Power",
        "dc_power11" : "DC_11 Power",
        "dc_power12" : "DC_12 Power",
        "frequency" : "Frequency",
        "temp" : "Temperature",     
      },
    },
    "ac_station_history": {
      "start_date": "Start Date",
      "end_date": "End Date",
      "location": "Location",
      "location2": "",
      "location_no": "AC Station",
      "time_interval": "Time Interval",
      "columns": {
        "time_stamp": "Update",
        "ac_all_power": "AC Power (kW)",
        "dc_all_power": "DC Power (kW)",
        "temp" : "Temperature (°C)",
        "sunshine": "Pyranometer (W/m2)",
        "today_kwh": "Today's Power (kWh)",
        "total_kwh": "Total Power (kWh)",
      },

    },
    "inverter_history": {
      "columns": {
        "Inver_No" : "Inverter No",
        "Invert" : "Inverter Table Name",
        "Invert_Name" : "Inverter Name",
        "STN" : "Station",
        "Time_Stamp" : "Update",
        "broken_line" : "Status",
        "today_kwh" : "Today's Power",
        "total_kwh" : "Total Power",
        "ac_avg_voltage" : "AC Average Voltage",
        "ac_avg_voltage_L" : "",
        "ac_total_current" : "AC Total Current",
        "ac_total_power" : "AC Total Power",
        "ac_voltage01" : "AC_01 Voltage",
        "ac_voltage02" : "AC_02 Voltage",
        "ac_voltage03" : "AC_03 Voltage",
        "ac_voltage_L_01" : "",
        "ac_voltage_L_02" : "",
        "ac_voltage_L_03" : "",
        "ac_current01" : "AC_01 Current",
        "ac_current02" : "AC_02 Current",
        "ac_current03" : "AC_03 Current",
        "ac_power01" : "AC_01 Power",
        "ac_power02" : "AC_02 Power",
        "ac_power03" : "AC_03 Power",
        "conversion" : "Conversion",
        "dc_avg_voltage" : "DC Average Voltage",
        "dc_total_current" : "DC Total Current",
        "dc_total_power" : "DC Total Power",
        "dc_voltage01" : "DC_01 Voltage",
        "dc_voltage02" : "DC_02 Voltage",
        "dc_voltage03" : "DC_03 Voltage",
        "dc_voltage04" : "DC_04 Voltage",
        "dc_voltage05" : "DC_05 Voltage",
        "dc_voltage06" : "DC_06 Voltage",
        "dc_voltage07" : "DC_07 Voltage",
        "dc_voltage08" : "DC_08 Voltage",
        "dc_voltage09" : "DC_09 Voltage",
        "dc_voltage10" : "DC_10 Voltage",
        "dc_voltage11" : "DC_11 Voltage",
        "dc_voltage12" : "DC_12 Voltage",
        "dc_current01" : "DC_01 Current",
        "dc_current02" : "DC_02 Current",
        "dc_current03" : "DC_03 Current",
        "dc_current04" : "DC_04 Current",
        "dc_current05" : "DC_05 Current",
        "dc_current06" : "DC_06 Current",
        "dc_current07" : "DC_07 Current",
        "dc_current08" : "DC_08 Current",
        "dc_current09" : "DC_09 Current",
        "dc_current10" : "DC_10 Current",
        "dc_current11" : "DC_11 Current",
        "dc_current12" : "DC_12 Current",
        "dc_power01" : "DC_01 Power",
        "dc_power02" : "DC_02 Power",
        "dc_power03" : "DC_03 Power",
        "dc_power04" : "DC_04 Power",
        "dc_power05" : "DC_05 Power",
        "dc_power06" : "DC_06 Power",
        "dc_power07" : "DC_07 Power",
        "dc_power08" : "DC_08 Power",
        "dc_power09" : "DC_09 Power",
        "dc_power10" : "DC_10 Power",
        "dc_power11" : "DC_11 Power",
        "dc_power12" : "DC_12 Power",
        "frequency" : "Frequency",
        "temp" : "Temperature",  
      },
      "start_date": "Start Date",
      "end_date": "End Date",
      "location": "Location",
      "location2": "",
      "location_no": "AC Station",
      "time_interval": "Time Interval",
      "inverter_no": "Inverter No",
    },
    "insolation_report": {
      "insolation_report": "Insolation Report",
      "columns": {
        "station_no": "Station No",
        "date_time": "DateTime",
        "today_mwh": "Today Mwh",
        "pr": "PR",
        "insolation": "Insolation",
      },
      "start_date": "Start Date",
      "end_date": "End Date",
    },
    "inverter_report": {
      "inverter_report": "Inverter Report",
      "columns": {
        "inverter_name": "Inverter Name",
        "today_power_generation": "Today Power Generation(kWh)",
        "total_power_generation": "Total Power Generation(MWh)",
      },
      "date": "Date",
    },
    "month_year_bar_chart": {
      "month_bar_chart": "Month Bar Chart",
      "day_bar_chart": "Day Bar Chart",
      "station": "Station",
      "data": "Data",
      "year": "Year",
      "month": "Month",
      "difference": "Difference",
    },
    "stations_trend_report_power": {
      "title" : "PR Value",
      "pr" : "PR",
      "hr" : "power generation hours",
      "search": {
        "bar_chart_month": "BAR CHART (MONTH)",
        "bar_chart_day": "BAR CHART (DAY)",
        "bar_chart_hour": "BAR CHART (HOUR)",
        "location": "Location",
        "year": "Year",
        "month": "Month",
        "date": "Date",
      }
    },
    "inverter_trend": {
      "allStn" : "All",
      "allStnCancel" : "null",
      "beg_date": "Start Date",
      "end_date": "End Date",
      "item": "Item",
      "device": "Inverter",
      "item_options": {
        "Inver_No" : "Inverter No",
        "Invert" : "Inverter Table Name",
        "Invert_Name" : "Inverter Name",
        "STN" : "Station",
        "Time_Stamp" : "Update",
        "broken_line" : "Status",
        "today_kwh" : "Today's Power",
        "total_kwh" : "Total Power",
        "ac_avg_voltage" : "AC Average Voltage",
        "ac_avg_voltage_L" : "",
        "ac_total_current" : "AC Total Current",
        "ac_total_power" : "AC Total Power",
        "ac_voltage01" : "AC_01 Voltage",
        "ac_voltage02" : "AC_02 Voltage",
        "ac_voltage03" : "AC_03 Voltage",
        "ac_voltage_L_01" : "",
        "ac_voltage_L_02" : "",
        "ac_voltage_L_03" : "",
        "ac_current01" : "AC_01 Current",
        "ac_current02" : "AC_02 Current",
        "ac_current03" : "AC_03 Current",
        "ac_power01" : "AC_01 Power",
        "ac_power02" : "AC_02 Power",
        "ac_power03" : "AC_03 Power",
        "conversion" : "Conversion",
        "dc_avg_voltage" : "DC Average Voltage",
        "dc_total_current" : "DC Total Current",
        "dc_total_power" : "DC Total Power",
        "dc_voltage01" : "DC_01 Voltage",
        "dc_voltage02" : "DC_02 Voltage",
        "dc_voltage03" : "DC_03 Voltage",
        "dc_voltage04" : "DC_04 Voltage",
        "dc_voltage05" : "DC_05 Voltage",
        "dc_voltage06" : "DC_06 Voltage",
        "dc_voltage07" : "DC_07 Voltage",
        "dc_voltage08" : "DC_08 Voltage",
        "dc_voltage09" : "DC_09 Voltage",
        "dc_voltage10" : "DC_10 Voltage",
        "dc_voltage11" : "DC_11 Voltage",
        "dc_voltage12" : "DC_12 Voltage",
        "dc_current01" : "DC_01 Current",
        "dc_current02" : "DC_02 Current",
        "dc_current03" : "DC_03 Current",
        "dc_current04" : "DC_04 Current",
        "dc_current05" : "DC_05 Current",
        "dc_current06" : "DC_06 Current",
        "dc_current07" : "DC_07 Current",
        "dc_current08" : "DC_08 Current",
        "dc_current09" : "DC_09 Current",
        "dc_current10" : "DC_10 Current",
        "dc_current11" : "DC_11 Current",
        "dc_current12" : "DC_12 Current",
        "dc_power01" : "DC_01 Power",
        "dc_power02" : "DC_02 Power",
        "dc_power03" : "DC_03 Power",
        "dc_power04" : "DC_04 Power",
        "dc_power05" : "DC_05 Power",
        "dc_power06" : "DC_06 Power",
        "dc_power07" : "DC_07 Power",
        "dc_power08" : "DC_08 Power",
        "dc_power09" : "DC_09 Power",
        "dc_power10" : "DC_10 Power",
        "dc_power11" : "DC_11 Power",
        "dc_power12" : "DC_12 Power",
        "frequency" : "Frequency",
        "temp" : "Temperature",
      },
    },
    "ac_station_trend": {
      "allStn" : "All",
      "allStnCancel" : "null",
      "beg_date": "Start Date",
      "end_date": "End Date",
      "item": "Item",
      "device": "AC Station",
      "item_options": {
        "ac_power": "AC Power",
        "dc_power": "DC Power",
        "today_kwh": "Today KWH",
        "total_kwh": "Total KWH",
        "sunshine_1": "Sunshine 1",
        "sunshine_2": "Sunshine 2",
        "wind_speed": "Wind Speed",
        "mode_temp": "Module Temperature",
        "air_temp": "Air Temperature 1",
        "air_temp_2": "Air Temperature 2",
        "air_humidity": "Air Humidity",
        "co2" : "CO2",
      },
    },
    "admin_users": {
      "title": "User Management",
      "RI": "Required Items",
      "add": " Create",
      "edit": " Edit",
      "columns": {
        "user_id": "User ID",
        "name": "User Name",
        "calories": "calories",
        "email": "Email",
        "cellphone": "Cellphone",
        "telephone": "Telephone",
        "password": "Password",
        "password1": "Confirm Password",
        "password2": "New Password",
        "password3": "Confirm New Password",
        "role": "Role",
        "station": "Check Station",
      },
      "message": {
        "id": "No account entered",
        "password": "No password entered",
        "checkPassword": "No confirmation password entered",
        "password_dc": "The two passwords are inconsistent, please enter the correct one",
        "name": "No name entered",
        "telephone": "The telephone number format is incorrect",
        "cellphone": "The cellphone number format is incorrect",
        "email": "Email format is incorrect",
        "roleStationSpec": "The Station of the case cannot be viewed",
        "delete_error": "Delete error",
        "update_error": "Update error",
        "success_error": "Success error",
        "delete": "Delete",
        "update": "Update",
        "success": "Success",
        "alart": "Alart",
        "delete_user": "Delete User？",
      }
    },
    "index_chart_base_line": {
      "title": "Index Chart Base Line",
      "title_setting": "Base Line Setting",
      "btn_ok": "SAVE",
      "btn_cancel": "CANCEL",
      "columns": {
        "month": "Month",
        "Today_kwh_Value": "Today Power Generation (MWh)",
        "PR_Value": "PR Value",
        "Updated_At": "Last updated",
      },
      "setting_box": {
        "month": "Month",
        "Today_kwh_Value": "Today Power Generation (MWh)",
        "PR_Value": "PR Value",
        "Updated_At": "Last updated",
      }
    },
    "22K_System": {
      "title": "Alarm List",
      "alarm": {
        "no": "No.",
        "location": "Location",
        "equipment": "Equipment",
        "alarm_time": "Alarm Time",
        "recovery_time": "Recovery Time",
        "message": "Message",
        "alarm_priority": "Alarm Priority",
        "value": "Value",
      },
    },
    "check_list": {
      "start_date": "Start Date",
      "end_date": "End Date",
      "status": "Status",
      "form_type_name": "Form Type",
      "form_type": {
        "A": "太陽光電模組檢查表",
        "B": "浮筒本體與支架結構",
        "C": "直流電纜線(4/125mm2)檢查表",
        "D": "直流匯流箱檢查表",
        "E": "桁架、錨碇系統與緩衝基座主體檢查表",
        "solar" : "太陽能光電模組檢查表",
        "dcbox" : "直流匯流箱檢查表",
        "sensor" : "日照/溫度模組",
        "inverter" : "逆變器",
      },
      "form_type_v2" : {
        "A": "Solar Photovoltaic Module",
        "B": "DC combiner box",
        "C": "Sunshine / Temperature Module",
        "D": "Inverter",
      },
      "columns": {
        "STN" : "STN",
        "form_type_name": "Form Type Name",
        "check_list_sn": "Form ID",
        "beg_date": "Start Date",
        "end_date": "End Date",
        "phase": "Phase",
        "owner_user_id": "Owner Name",
        "assign_user_id": "Assign Name",
        "updated_at": "Update Time",
      },
    },
    "check_list_detail": {
      "stn" : "Station",
      "formId": "Form ID",
      "formIdSub" : "The system auto generates a form number ",
      "formStatus": "Phase",
      "form": "Check List",
      "formSub": "Check List Schedule",
      "formCheckItem": "Form Check Item",
      "formINfoError": "Form Information Eorror",
      "owner": "Owner User",
      "assign": "Assign User",
      "formItem": "item",
      "formCheckContent": "check content",
      "formCycle": "inspection cycle",
      "formRemark": "Remark",
      "formReportResult": "Report result",
      "formMustCheck": "This table must check items",
      "checkTime": "Check Time",
      "checkStart": "Start Time",
      "checkEnd": "End Time",
      "assignError": "Assign User not yet specified",
      "checkTimeError": "End time cannot be earlier than start time",
      "send": "Assign",
      "resend": "RE Assign",
      "device": "Device",
      "deviceCkeckTime": "Device Ckeck Time",
     "item1": "1. Check Result",
      "item2": "2. Check Result",
      "item3": "3. Check Result",
      "item4": "4. Check Result",
      "item5": "5. Check Result",
      "item6": "6. Check Result",
      "item7": "7. Check Result",
      "item8": "8. Check Result",
      "item9": "9. Check Result",
      "item10": "10. Check Result",
      "item11": "11. Check Result",
      "item12": "12. Check Result",
      "item13": "13. Check Result",
      "item14": "14. Check Result",
      "item15": "15. Check Result",
      "remarkInfo": "備註(如交代檢查事項)",
      "resultInfo": "OK: 110, Exception: 5, Exception Fix: 5, None: 0, Not yet checked: 0",
      "content_1": "※ 檢査結果以標記說明，正常：V， 異常：X， 異常修復：Δ， 無此項: NA",
      "content_2": "模組現場功率檢測30串/片(I-V Tester)",
      "content_3": "Click here to enter a message",
      "upload": "Photos uploaded",
      "notupload": "No photo uploaded",
      "uploadSize": "Please select a photo within 2M",
      "alart": "Alart",
      "notCheckItem": "Not this inspection item",
      "formUpOk": "The update form is successful, and return to the inspection table management after five seconds",
      "formAddOk": "The new form is successfully added, and it will return to the inspection table management after five seconds",
      "formAddErr": "Update form failed",
      "formUpErr": "Failed to add form",
      "formSaveToDraft": "Save as draft?",
      "formSaveToAssign": "Are you sure you want to assign it?",
      "formSaveToTempExceute": "Save current record?",
      "formSaveToTempItem": "Do you want to save the current check content record?",
      "formToVoid": "Are you sure you want to invalidate this checklist?",
      "formtoVoidOk": "This form has been invalidated and returned to inspection form management.",
      "formtoVoidErr": "Form change invalidation failed",
      "formToComplete": "Are you sure you have checked all equipment?",
      "formToCompleteOk": "This form has been completed, return to inspection form management",
      "formToCompleteErr": "Form change completion failed",
      "formToReExecute": "Are you sure you want to reassign the staff?",
      "formToReExecuteOk": "This form has been reassigned, return to inspection table management",
      "formToReExecuteErr": "Form change redispatch failed",
      "formToEnd": "Are you sure you want to close this checklist?",
      "formToEndOk": "This form has been closed, return to inspection form management",
      "formToEndErr": "Form change closing failed",
      "owner_notes" : "Notes to assignee",
      "assign_notes" : "Staff remarks",
      "owner_notes_content" : "Message from assignee to staff",
      "assign_notes_content" : "Total return of reporting personnel",
      "select_stn" : "Please select the case Station",
      "select_assign" : "Please select a staff member",
      "select_beg_date" : "Please select a start time",
      "select_end_date" : "Please select end time",
      "select_date_error" : "Check end time cannot be earlier than start time",
      "dispatch_chcek": {
        "normal": "ok",
        "err": "error",
        "err_fix": "error fix",
        "na": "na",
        "not_yet": "not yet",
      },
      "item" : {
        "A":{
          "item_1": "*Check whether the module is damaged, scratched, or discolored",
          "item_2": "Check the appearance of the cable (MC4 connector) for damage.",
          "item_3": "Are the fixing screws and nuts of the frame and bracket loose?",
          "item_4": "* Whether the ground wire of the frame is damaged and whether the ground terminal is loose",
          "item_5": "Clearance of shade from surrounding environment",
          "item_6": "Module on-site power detection",
        },
        "B" : {
          "item_1": "Check whether the surface of the box is corroded, damaged or deformed",
          "item_2": "Check whether there is water leakage inside the box",
          "item_3": "Inspect and clean the inside of the box",
          "item_4": "Check and clean the environment around the box",
          "item_5": "Check whether there are warning signs posted on the front of the box or damaged ones.",
          "item_6": "*Check whether the circuit diagram is placed inside the box",
          "item_7": "Check whether the internal wiring is neat",
          "item_8": "Check whether the internal wiring is damaged and whether the terminals are loose",
          "item_9": "Check whether the ground wire is damaged and whether the terminal is loose",
          "item_10": "Check whether the external cable is damaged and whether the connecting terminal is loose",
          "item_11": "Check whether the switch contacts are loose",
          "item_12": "Check if the fuse is blown",
          "item_13": "*Check the temperature of various components and joints inside the handheld thermal imager box (>75℃ is abnormal)",
          "item_14": "Check whether the surge absorber is burned out or abnormal",
          "item_15": "Ground wire ground resistance check (< 10 Ω)",
        },
        "C" : {
          "item_1": "Is there any dirt on the surface of the sunshine meter?",
          "item_2": "A sun meter detects surface damage",
          "item_3": "Is the module thermometer attached to the solar module and not falling off?",
          "item_4": "Check whether the device communication parameters are correct",
        },
        "D" : {
          "item_1" : "Check whether the surface of the equipment is corroded, damaged or deformed",
          "item_2" : "Check whether there are warning signs posted on the front of the box or damaged ones.",
          "item_3" : "Check whether the equipment wiring is damaged and whether the terminals are loose",
          "item_4" : "Check whether the external cable is damaged and whether the connecting terminal is loose",
          "item_5" : "Check whether the device communication module is loose",
          "item_6" : "Check whether the device communication parameters are correct",
          "item_7" : "Are the fixing screws and nuts of the frame and bracket loose?",
          "item_8" : "Check whether the grounding of the frame is damaged and whether the ground terminal is loose.",
        },
      },
    },
    "station_setting": {
      "alarm": "Alarm！",
      "update": "Are you sure you want to update your profile？",
      "res_update_s": "update completed",
      "res_update_e": "update failed",
      "delete_pic": "Are you sure you want to delete the picture？",
      "delete": "Are you sure you want to delete the data？",
      "res_delete_s": "successfully deleted",
      "res_delete_e": "failed to delete",
      "intday": "Please enter an integer",
      "stnMes": "The system automatically defines the case number",
      "columns": {
        "STN": "NO",
        "Name": "Name",
        "Capacity": "Capacity",
        "Inverter": "Inverter Qty",
        "InsretDay": "Insret Day",
        "INV_PR_Limit": "INV-PR low warning factor",
        "MPPT_RA_Limit": "MPPT-RA low warning factor",
        "INV_PR_Limit_Days": "INV-PR Low Alert Consecutive Days",
        "MPPT_RA_Limit_Days": "MPPT-RA Low Alert Consecutive Days",
        "AI_Solar_Panel_Clear_Days": "Number of consecutive days to clean solar panels",
        "INV_PR_Device_Limit": "Cleaning rate of solar panel equipment",
        "station_main_picture": "Station main picture - Single",
        "station_multi_picture": "Station multi picture - Multiple",
      },
    },
    "inverter_setting": {
      "alarm": "Alarm",
      "update": "Are you sure you want to update your profile",
      "res_update_s": "update completed",
      "res_update_e": "update failed",
      "columns": {
        "stn_no": "NO",
        "stn_name": "Name",
        "inv_no": "Inverter NO",
        "inv_name": "Inverter Name",
        "insert_day": "Insret Day",
        "brand": "Brand",
        "brand_model": "Brand Model",
        "capacity": "Capacity",
        "real_capacity": "Real Capacity",
        "sunshine_no": "Sunshine NO",
        "sunshine_name": "Sunshine Name",
        "mppt_toggle_1": "MPPT-01 Capacity",
        "mppt_toggle_2": "MPPT-02 Capacity",
        "mppt_toggle_3": "MPPT-03 Capacity",
        "mppt_toggle_4": "MPPT-04 Capacity",
        "mppt_toggle_5": "MPPT-05 Capacity",
        "mppt_toggle_6": "MPPT-06 Capacity",
        "mppt_toggle_7": "MPPT-07 Capacity",
        "mppt_toggle_8": "MPPT-08 Capacity",
        "mppt_toggle_9": "MPPT-09 Capacity",
        "mppt_toggle_10": "MPPT-10 Capacity",
        "mppt_toggle_11": "MPPT-11 Capacity",
        "mppt_toggle_12": "MPPT-12 Capacity",
        "mppt_toggle_13": "MPPT-13 Capacity",
        "mppt_toggle_14": "MPPT-14 Capacity",
        "mppt_toggle_15": "MPPT-15 Capacity",
        "mppt_toggle_16": "MPPT-16 Capacity",
      },
    },
    "station_map": {
      "all_station_info": {
        "title": "Area - All Station",
        "title_city": "Area - ",
        "today_power_hr": "Power Hour",
        "today_power_lux": "Sunshine",
        "today_power_kWh": "Today's Power",
        "today_power_now": "Instant Power",
        "today_power_money": "Power Amount",
      },
      "today_power_hr": {
        "title": "Top five in the power generation hours",
      },
      "map": {
        "today_power_total": "Total Power",
        "today_power_lux": "Sunshine",
        "today_power_kWh": "Today's Power",
        "today_power_now": "Instant Power",
        "today_power_money": "Power Amount",
        "status": "Status",
        "open" : "Open Dashboard",
      }
    },
    "station_overview": {
      "alarm" : "Alarm",
      "message" : "Go to this station dashboard?",
      "all_station_info": {
        "power_station": "Station",
        "device_capacity": "Capacity",
        "today_power_kWh": "Today's Power",
        "today_power_hour": "Today's Power Hours",
        "today_power_money": "Today's Power Amount",
        "today_power_lux": "Pyranometer",
        "today_power_now": "Power",
        "amount" : "Amount",
        "update" : "Update",
        "status" : "Status",
      },
    },
    "station_dashboard": {
      "site_title_info": {
        "stn_name": "Name",
        "stn_unit": "NO",
        "stn_addr": "Address",
        "install_capacity": "Capacity",
        "install_time": "Install Day",
        "inv_unit": "Inverter Qty",
        "sys_status": "System Status",
      },
      "ac_power_trend": {
        "title": "Power",
      },
      "picture_carousel": {
        "not_data": "No Picture"
      },
      "month_power_trend": {
        "today_power_kWh": "Today's Power",
        "today_power_money": "Today's Power Amount",
        "today_power_hr": "Today's Power Hours",
        "power_kWh": "Power",
        "power_money": "Power Amount",
        "power_hr": "Power Hours",
        "pr_value": "PR Value",
        "forecast_power": "Forecast Power",
        "forecast_pr": "Forecast PR",
        "total_power": "Total Power Generation",
        "co2": "Carbon reduction",
      },
      "inverter_link_status": {
        "title": "Station Inverter Status",
        "btnlabel": "Inverter + Breaker",
        "inverter": "Inverter",
        "today_power": "Today's Power (kWh)",
        "status": "Status",
        "cb_status": "CB_Status",
      },
    },
    "admin_page_permission_setting":{
      "columns": {
        "role_name" : "Role Name",
        "view_page" : "Page Permission Setting",
      },
    },
    "thirty_days_avg_pr":{
      "columns": {
        "STN" : "NO",
        "Name" : "Name",
        "update" : "Update",
        "pr" : "The average PR value of the previous 30 days",
      },
    },
    "upload_and_each_alarm_status" :{
      "normal" : "Normal",
      "delay" : "Delay",
      "update" : " Update",
      "not_update" : " Not Yet",
      "have" : "Have",
      "not_have" : "None",
      "columns": {
        "STN" : "No",
        "Name" : "Name",
        "update" : "Update",
        "stn_broken" : "Station Broken",
        "inv_broken" : "Inverter Broken",
        "update_status" : "Update Status",
        "inv_alarm" : "Inverter Alarm",
        "dab_alarm" : "Dab Alarm",
        "temp_and_shine_alarm" : "Temperature or Sunshine Alarm",
        "meter_alarm" : "Meter Alarm",
        "relay_alarm" : "Relay Alarm",
        "plant_alarm" : "Plant Alarm",
      },
    }
  },
  "menu": {
    "index": "Home",
    "station_map": "Station Map",
    "station_menu": "Station Menu",
    "station_overview": "Station Overview",
    "station_list": "Station List",
    "inverter_list": "Inverter Instant Data",
    "alarm_list": "Device Alarm List",
    "alarm_list_confirm": "Alarm List Confirm",
    "power_history_data": "Power History Data",
    "hv_room": "HV Room",
    "ac_station_history": "AC Station",
    "inverter_history": "Inverter",
    "power_collect_data": "Power Collect Data",
    "insolation_report": "Insolation Report",
    "inverter_report": "Inverter Report",
    "weather_data": "Weather Data",
    "weather_report": "Weather Report",
    "weather_summary": "Weather Summary",
    "trend_report": "Trend/Report",
    "month_year_bar_chart": "Average Power Generation hours",
    "stations_trend_report_pr": "PR",
    "test": "TEST",
    "admin": "Management",
    "admin_users": "User Management",
    "sample": "sample",
    "sample_data_table": "sample data table",
    "stn_index": "Station Home",
    "stn_inverter_data": "Inverter Data",
    "stn_alarm_list": "Alarm List",
    "index_chart_base_line": "Index Chart Base Line",
    "check_list": "Inspection Dispatch",
    "22k_system": "22K System",
    "69k_system": "69K System",
    "my_pvsingle": "my PVSingle",
    "inverter_trend": "Inverter Trend",
    "ac_station_trend": "AC Station Trend",
    "check_list_dispatch": "Dispatch Check",
    "alarm_dispatch": "Alarm Dispatch",
    "maintenance_management": "Maintenance",
    "station_setting": "Station Setting",
    "inverter_setting": "Inverter Setting",
    "real_time_monitoring": "Instant Monitoring",
    "station_dashboard": "Station Dashboard",
    "ai_alarm_list": "AI Alarm List",
    "stn_data_alarm_list": "Station Energy Alarm List",
    "alarm_menu" : "Alarm Menu",
    "regional_analysis" : "Regional Analysis",
    "admin_page_permission_setting" : "Page Permission Setting",
    "station_cctv" : "Station CCTV",
    "thirty_days_avg_pr" : "Thirty Days Avg PR",
    "upload_and_each_alarm_status" : "Upload and Each Alarm Status",
    "check_list_ver2" : "Inspection Dispatch Ver2",
  },
  "taiwan_place": {
    "keelung_city": "Keelung City",
    "new_taipei_city": "New Taipei City",
    "taipei_city": "Taipei City",
    "taoyuan_city": "Taoyuan City",
    "hsinchu_county": "Hsinchu County",
    "hsinchu_city": "Hsinchu City",
    "miaoli_city": "Miaoli City",
    "miaoli_county": "Miaoli County",
    "taichung_city": "Taichung City",
    "changhua_county": "Changhua County",
    "changhua_city": "Changhua City",
    "nantou_city": "Nantou City",
    "nantou_county": "Nantou County",
    "yunlin_county": "Yunlin County",
    "chiayi_county": "Chiayi County",
    "chiayi_city": "Chiayi City",
    "tainan_city": "Tainan City",
    "kaohsiung_city": "Kaohsiung City",
    "pingtung_county": "Pingtung County",
    "pingtung_city": "Pingtung City",
    "yilan_county": "Yilan County",
    "yilan_city": "Yilan City",
    "hualien_county": "Hualien County",
    "hualien_city": "Hualien City",
    "taitung_city": "Taitung City",
    "taitung_county": "Taitung County",
    "penghu_county": "Penghu County",
    "green_island": "Green Island",
    "orchid_island": "Orchid Island",
    "kinmen_county": "Kinmen County",
    "matsu": "Matsu",
    "lienchiang_county": "Lienchiang County",
  },
  "api_msg": { // 後端的 message 訊息
    "menu": {
      "test": "test menu",
    }
  },
};