var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_business_list",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      search: {
        store: "1",
        start_date: moment().format("YYYY/MM/DD"),
        end_date: moment().format("YYYY/MM/DD"),
      },
      edit_cash_warn_info: {
        show: false, // 編輯零用金版面顯示
        show_edit_btn: false, // 編輯零用金按鈕
        show_delete_btn: false, // 刪除零用金按鈕

        editUserDisable: false, // 編輯那些資料不能更新設定
        store_id: null, //門市編號
        cash_warning_level: null, // 鈔票警告水位
        cash_stop_level: null, // 鈔票即停水位
        cash_overflow_warning_level: null, // 溢幣區(鈔票)警告水位
        cash_overflow_stop_level: null, // 溢幣區(鈔票)停止水位
        coin_warning_water_level: null, // 硬幣警告水位
        coin_stop_water_level: null, // 硬幣停止水位
        coin_overflow_warning_level: null, // 溢幣區(硬幣)警告水位
        coin_overflow_stop_level: null, // 溢幣區(硬幣)停止水位

        enabled: false,
      },
      excel_name: "DailyInfo",
    };
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "transaction_date",
          required: true,
          label: this.$t("page.store_business_list.columns.transaction_date"),
          align: "left",
          field: "transaction_date",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = "";
            if (data != null) {
              dt = moment(data).format("YYYY-MM-DD");
            }
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 0,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cashier_id",
          label: this.$t("page.store_business_list.columns.cashier_id"),
          align: "left",
          field: "cashier_id",
          $$only_excel: true,
          $$excel_index: 1,
          $$is_num_format: false,
        },
        {
          name: "store_id",
          required: true,
          label: this.$t("page.store_business_list.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 2,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_name",
          label: this.$t("page.store_business_list.columns.store_name"),
          align: "left",
          field: "store_name",
          $$only_excel: true,
          $$excel_index: 3,
          $$is_num_format: false,
        },
        {
          name: "total_amount",
          required: true,
          label: this.$t("page.store_business_list.columns.total_amount"),
          align: "left",
          field: "total_amount",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 4,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_1000",
          required: true,
          label: this.$t("page.store_business_list.columns.cash_1000"),
          align: "left",
          field: "cash_1000",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 5,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_500",
          required: true,
          label: this.$t("page.store_business_list.columns.cash_500"),
          align: "left",
          field: "cash_500",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 6,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_100",
          required: true,
          label: this.$t("page.store_business_list.columns.cash_100"),
          align: "left",
          field: "cash_100",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 7,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_50",
          required: true,
          label: this.$t("page.store_business_list.columns.cash_50"),
          align: "left",
          field: "cash_50",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 8,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_10",
          required: true,
          label: this.$t("page.store_business_list.columns.cash_10"),
          align: "left",
          field: "cash_10",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 9,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_5",
          required: true,
          label: this.$t("page.store_business_list.columns.cash_5"),
          align: "left",
          field: "cash_5",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 10,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_1",
          required: true,
          label: this.$t("page.store_business_list.columns.cash_1"),
          align: "left",
          field: "cash_1",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 11,
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //excel 報表匯出 名稱定義
    excel_name_str() {
      let res = "";
      let store = "";
      let that = this;
      if (this.search.store != 0) {
        this.store.forEach(el => {
          if (el.value == that.search.store) {
            store = `_${el.label}`;
          }
        });
      }
      res = `${this.excel_name}ExportExcel${store}`;
      return res;
    }
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      that.$q.loading.show();
      var params = {
        Action: "BusinessList",
        Datas: that.search,
      };
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
