var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_cash_warn_setting",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      search: {
        store: "1",
      },
      select_store: [],
      //各部位最大數量
      base_max_amount: {
        //發鈔錢箱最大數量 需區分面額 (2024/04/17紀錄:目前僅使用100的位置)
        sub_500_out: 1200,
        sub_100_out: 1200,
        //硬幣 需區分面額
        cycel_50_out: 700,
        cycel_10_out: 900,
        cycel_5_out: 1200,
        cycel_1_out: 1500,
        //鈔票錢箱(鈔票保全箱) 數量沒有區分面額
        safe_cash_box: 600,
        //溢幣區最大數量 數量沒有區分面額
        safe_coin_box: 3000,
      },
      edit_cash_warn_info: {
        show: false, // 編輯零用金版面顯示
        show_store_info: false, // 顯示門市編號及門市名稱 ((多選設定下圍false 僅單一門市設定時為true
        show_edit_btn: false, // 編輯零用金按鈕
        show_delete_btn: false, // 刪除零用金按鈕

        editUserDisable: false, // 編輯那些資料不能更新設定
        store_id: null, //門市編號
        store_name: null, //門市編號
        cash_warning_level: 0, // 發鈔前箱警告水位
        cash_stop_level: 0, // 發鈔前箱即停水位
        cash_overflow_warning_level: 0, // 鈔票錢箱(鈔票保全箱)警告水位
        cash_overflow_stop_level: 0, // 鈔票錢箱(鈔票保全箱)停止水位
        coin_low_warning_water_level: 0, // (低水位) 硬幣警告水位
        coin_low_stop_water_level: 0, // (低水位) 硬幣停止水位
        coin_overflow_warning_level: 0, // (高水位)溢幣區(硬幣)警告水位 (與硬幣循環區共用設定)
        coin_overflow_stop_level: 0, // (高水位)溢幣區(硬幣)停止水位 (與硬幣循環區共用設定)
        //門市零用金資訊 (用來計算低水位判斷)
        store_allowance: {
          //發鈔錢箱零用金設定值
          sub_500_out: 0,
          sub_100_out: 0,
          //硬幣零用金設定值 需區分面額
          cycel_50_out: 0,
          cycel_10_out: 0,
          cycel_5_out: 0,
          cycel_1_out: 0,
        },

        enabled: false,
      },
    };
  },
  watch: {
    "edit_cash_warn_info.cash_warning_level": {
      handler(nv, ov) {
        if (parseFloat(nv) > 75) {
          this.edit_cash_warn_info.cash_warning_level = 75;
        } else if (parseFloat(nv) < 1) {
          this.edit_cash_warn_info.cash_warning_level = 1;
        } else {
          this.edit_cash_warn_info.cash_warning_level = parseInt(nv);
        }
      },
    },
    "edit_cash_warn_info.cash_stop_level": {
      handler(nv, ov) {
        if (parseFloat(nv) > 75) {
          this.edit_cash_warn_info.cash_stop_level = 75;
        } else if (parseFloat(nv) < 1) {
          this.edit_cash_warn_info.cash_stop_level = 1;
        } else {
          this.edit_cash_warn_info.cash_stop_level = parseInt(nv);
        }
      },
    },
    "edit_cash_warn_info.cash_overflow_warning_level": {
      handler(nv, ov) {
        if (parseFloat(nv) > 100) {
          this.edit_cash_warn_info.cash_overflow_warning_level = 100;
        } else if (parseFloat(nv) < 85) {
          this.edit_cash_warn_info.cash_overflow_warning_level = 85;
        } else {
          this.edit_cash_warn_info.cash_overflow_warning_level = parseInt(nv);
        }
      },
    },
    "edit_cash_warn_info.cash_overflow_stop_level": {
      handler(nv, ov) {
        if (parseFloat(nv) > 100) {
          this.edit_cash_warn_info.cash_overflow_stop_level = 100;
        } else if (parseFloat(nv) < 85) {
          this.edit_cash_warn_info.cash_overflow_stop_level = 85;
        } else {
          this.edit_cash_warn_info.cash_overflow_stop_level = parseInt(nv);
        }
      },
    },
    "edit_cash_warn_info.coin_low_warning_water_level": {
      handler(nv, ov) {
        if (parseFloat(nv) > 75) {
          this.edit_cash_warn_info.coin_low_warning_water_level = 75;
        } else if (parseFloat(nv) < 1) {
          this.edit_cash_warn_info.coin_low_warning_water_level = 1;
        } else {
          this.edit_cash_warn_info.coin_low_warning_water_level = parseInt(nv);
        }
      },
    },
    "edit_cash_warn_info.coin_low_stop_water_level": {
      handler(nv, ov) {
        if (parseFloat(nv) > 75) {
          this.edit_cash_warn_info.coin_low_stop_water_level = 75;
        } else if (parseFloat(nv) < 1) {
          this.edit_cash_warn_info.coin_low_stop_water_level = 1;
        } else {
          this.edit_cash_warn_info.coin_low_stop_water_level = parseInt(nv);
        }
      },
    },
    "edit_cash_warn_info.coin_overflow_warning_level": {
      handler(nv, ov) {
        if (parseFloat(nv) > 100) {
          this.edit_cash_warn_info.coin_overflow_warning_level = 100;
        } else if (parseFloat(nv) < 85) {
          this.edit_cash_warn_info.coin_overflow_warning_level = 85;
        } else {
          this.edit_cash_warn_info.coin_overflow_warning_level = parseInt(nv);
        }
      },
    },
    "edit_cash_warn_info.coin_overflow_stop_level": {
      handler(nv, ov) {
        if (parseFloat(nv) > 100) {
          this.edit_cash_warn_info.coin_overflow_stop_level = 100;
        } else if (parseFloat(nv) < 85) {
          this.edit_cash_warn_info.coin_overflow_stop_level = 85;
        } else {
          this.edit_cash_warn_info.coin_overflow_stop_level = parseInt(nv);
        }
      },
    },
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "store_id",
          required: true,
          label: this.$t("page.store_cash_warn_setting.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_name",
          required: true,
          label: this.$t("page.store_cash_warn_setting.columns.store_name"),
          align: "left",
          field: "store_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_warning_level",
          required: true,
          label: this.$t(
            "page.store_cash_warn_setting.columns.cash_warning_level"
          ),
          align: "left",
          field: "cash_warning_level",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            return data + "%";
          },
          classes: "table-title-warning",
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_stop_level",
          required: true,
          label: this.$t(
            "page.store_cash_warn_setting.columns.cash_stop_level"
          ),
          align: "left",
          field: "cash_stop_level",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            return data + "%";
          },
          classes: "table-title-stop",
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "coin_low_warning_water_level",
          required: true,
          label: this.$t(
            "page.store_cash_warn_setting.columns.coin_warning_water_level"
          ),
          align: "left",
          field: "coin_low_warning_water_level",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            return data + "%";
          },
          classes: "table-title-warning",
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "coin_low_stop_water_level",
          required: true,
          label: this.$t(
            "page.store_cash_warn_setting.columns.coin_stop_water_level"
          ),
          align: "left",
          field: "coin_low_stop_water_level",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            return data + "%";
          },
          classes: "table-title-stop",
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_overflow_warning_level",
          required: true,
          label: this.$t(
            "page.store_cash_warn_setting.columns.cash_overflow_warning_level"
          ),
          align: "left",
          field: "cash_overflow_warning_level",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            return data + "%";
          },
          classes: "table-title-warning",
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_overflow_stop_level",
          required: true,
          label: this.$t(
            "page.store_cash_warn_setting.columns.cash_overflow_stop_level"
          ),
          align: "left",
          field: "cash_overflow_stop_level",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            return data + "%";
          },
          classes: "table-title-stop",
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "coin_overflow_warning_level",
          required: true,
          label: this.$t(
            "page.store_cash_warn_setting.columns.coin_overflow_warning_level"
          ),
          align: "left",
          field: "coin_overflow_warning_level",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            return data + "%";
          },
          classes: "table-title-warning",
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "coin_overflow_stop_level",
          required: true,
          label: this.$t(
            "page.store_cash_warn_setting.columns.coin_overflow_stop_level"
          ),
          align: "left",
          field: "coin_overflow_stop_level",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            return data + "%";
          },
          classes: "table-title-stop",
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    // 異常訊息
    message_alart() {
      return [
        {
          label: "更新成功",
          value: this.$t("page.store_cash_warn_setting.message.update"),
        },
        {
          label: "更新失敗",
          value: this.$t("page.store_cash_warn_setting.message.update_error"),
        },
        {
          label: "更新失敗",
          value: this.$t(
            "page.store_cash_warn_setting.message.update_error_level"
          ),
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //自動計算各面額的水位數量計算 用於顯示
    auto_count() {
      var auto_count = {
        cash_warning_level_500: 0,
        cash_warning_level_100: 0,
        cash_stop_level_500: 0,
        cash_stop_level_100: 0,
        cash_overflow_warning_level: 0,
        cash_overflow_stop_level: 0,
        coin_warning_water_level_50: 0,
        coin_warning_water_level_10: 0,
        coin_warning_water_level_5: 0,
        coin_warning_water_level_1: 0,
        coin_stop_water_level_50: 0,
        coin_stop_water_level_10: 0,
        coin_stop_water_level_5: 0,
        coin_stop_water_level_1: 0,
        coin_overflow_warning_level_50: 0,
        coin_overflow_warning_level_10: 0,
        coin_overflow_warning_level_5: 0,
        coin_overflow_warning_level_1: 0,
        coin_overflow_stop_level_50: 0,
        coin_overflow_stop_level_10: 0,
        coin_overflow_stop_level_5: 0,
        coin_overflow_stop_level_1: 0,
      };
      //發鈔前箱警告水位數量 (低水位判斷 使用零用金來做計算)
      auto_count.cash_warning_level_500 = Math.ceil(
        this.base_max_amount.sub_500_out *
          (this.edit_cash_warn_info.cash_warning_level / 100)
      );
      auto_count.cash_warning_level_100 = `${Math.ceil(
        this.edit_cash_warn_info.store_allowance.sub_100_out *
          (this.edit_cash_warn_info.cash_warning_level / 100)
      )}/${this.edit_cash_warn_info.store_allowance.sub_100_out}`;
      //發鈔前箱停止水位數量  (低水位判斷 使用零用金來做計算)
      auto_count.cash_stop_level_500 = Math.ceil(
        this.base_max_amount.sub_500_out *
          (this.edit_cash_warn_info.cash_stop_level / 100)
      );
      auto_count.cash_stop_level_100 = `${Math.ceil(
        this.edit_cash_warn_info.store_allowance.sub_100_out *
          (this.edit_cash_warn_info.cash_stop_level / 100)
      )}/${this.edit_cash_warn_info.store_allowance.sub_100_out}`;
      //鈔票前箱警告水位數量
      auto_count.cash_overflow_warning_level = Math.ceil(
        this.base_max_amount.safe_cash_box *
          (this.edit_cash_warn_info.cash_overflow_warning_level / 100)
      );
      //鈔票前箱停止水位數量
      auto_count.cash_overflow_stop_level = Math.ceil(
        this.base_max_amount.safe_cash_box *
          (this.edit_cash_warn_info.cash_overflow_stop_level / 100)
      );
      //硬幣警告水位 (低水位判斷 使用零用金來計算)
      auto_count.coin_warning_water_level_50 = Math.ceil(
        this.edit_cash_warn_info.store_allowance.cycel_50_out *
          (this.edit_cash_warn_info.coin_low_warning_water_level / 100)
      );
      auto_count.coin_warning_water_level_10 = Math.ceil(
        this.edit_cash_warn_info.store_allowance.cycel_10_out *
          (this.edit_cash_warn_info.coin_low_warning_water_level / 100)
      );
      auto_count.coin_warning_water_level_5 = Math.ceil(
        this.edit_cash_warn_info.store_allowance.cycel_5_out *
          (this.edit_cash_warn_info.coin_low_warning_water_level / 100)
      );
      auto_count.coin_warning_water_level_1 = Math.ceil(
        this.edit_cash_warn_info.store_allowance.cycel_1_out *
          (this.edit_cash_warn_info.coin_low_warning_water_level / 100)
      );
      //硬幣停止水位 (低水位判斷 使用零用金來計算)
      auto_count.coin_stop_water_level_50 = Math.ceil(
        this.edit_cash_warn_info.store_allowance.cycel_50_out *
          (this.edit_cash_warn_info.coin_low_stop_water_level / 100)
      );
      auto_count.coin_stop_water_level_10 = Math.ceil(
        this.edit_cash_warn_info.store_allowance.cycel_10_out *
          (this.edit_cash_warn_info.coin_low_stop_water_level / 100)
      );
      auto_count.coin_stop_water_level_5 = Math.ceil(
        this.edit_cash_warn_info.store_allowance.cycel_5_out *
          (this.edit_cash_warn_info.coin_low_stop_water_level / 100)
      );
      auto_count.coin_stop_water_level_1 = Math.ceil(
        this.edit_cash_warn_info.store_allowance.cycel_1_out *
          (this.edit_cash_warn_info.coin_low_stop_water_level / 100)
      );

      //溢幣區警告水位 (高水位判斷 使用最大容量來計算)
      auto_count.coin_overflow_warning_level_50 = Math.ceil(
        this.base_max_amount.cycel_50_out *
          (this.edit_cash_warn_info.coin_overflow_warning_level / 100)
      );
      auto_count.coin_overflow_warning_level_10 = Math.ceil(
        this.base_max_amount.cycel_10_out *
          (this.edit_cash_warn_info.coin_overflow_warning_level / 100)
      );
      auto_count.coin_overflow_warning_level_5 = Math.ceil(
        this.base_max_amount.cycel_5_out *
          (this.edit_cash_warn_info.coin_overflow_warning_level / 100)
      );
      auto_count.coin_overflow_warning_level_1 = Math.ceil(
        this.base_max_amount.cycel_1_out *
          (this.edit_cash_warn_info.coin_overflow_warning_level / 100)
      );
      //溢幣區停止水位 (高水位判斷 使用最大容量來計算)
      auto_count.coin_overflow_stop_level_50 = Math.ceil(
        this.base_max_amount.cycel_50_out *
          (this.edit_cash_warn_info.coin_overflow_stop_level / 100)
      );
      auto_count.coin_overflow_stop_level_10 = Math.ceil(
        this.base_max_amount.cycel_10_out *
          (this.edit_cash_warn_info.coin_overflow_stop_level / 100)
      );
      auto_count.coin_overflow_stop_level_5 = Math.ceil(
        this.base_max_amount.cycel_5_out *
          (this.edit_cash_warn_info.coin_overflow_stop_level / 100)
      );
      auto_count.coin_overflow_stop_level_1 = Math.ceil(
        this.base_max_amount.cycel_1_out *
          (this.edit_cash_warn_info.coin_overflow_stop_level / 100)
      );
      return auto_count;
    },
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      var params = {
        Action: "CashWarnList",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },

    //	關閉設定畫面
    cancel_store_cash_warn() {
      this.edit_cash_warn_info["show"] = false;
    },
    //	開啟設定畫面
    open_edit_store_cash_warn(rowData) {
      let that = this;
      that.$q.loading.show();
      //清除暫存資料
      this.$data.edit_cash_warn_info = this.$options.data().edit_cash_warn_info;
      //設定多門市
      if (rowData == "all") {
        if (this.select_store.length == 0) {
          that.FnNotify(
            `${that.$t(
              "page.store_cash_warn_setting.message.no_select_store"
            )}`,
            "error"
          );
        } else {
          that.edit_cash_warn_info["show"] = true;
          that.edit_cash_warn_info["show_edit_btn"] = true;
          var store_id_list = [];
          this.select_store.forEach((el) => {
            store_id_list.push(el.store_id);
          });
          that.edit_cash_warn_info["store_id"] = store_id_list.toString();
          that.edit_cash_warn_info["show_edit_btn"] = true;
          that.edit_cash_warn_info["show"] = true;
        }
        that.$q.loading.hide();
      }
      //設定單一門市
      else {
        var param = {
          Action: "EditCashWarn",
          Datas: {
            store_id: rowData.store_id,
          },
        };
        that
          .FnWebAPIGet(param)
          .then(function (res) {
            that.edit_cash_warn_info["cash_warning_level"] =
              res.data.data.cash_warning_level;
            that.edit_cash_warn_info["cash_stop_level"] =
              res.data.data.cash_stop_level;
            that.edit_cash_warn_info["cash_overflow_warning_level"] =
              res.data.data.cash_overflow_warning_level;
            that.edit_cash_warn_info["cash_overflow_stop_level"] =
              res.data.data.cash_overflow_stop_level;
            that.edit_cash_warn_info["coin_low_warning_water_level"] =
              res.data.data.coin_low_warning_water_level;
            that.edit_cash_warn_info["coin_low_stop_water_level"] =
              res.data.data.coin_low_stop_water_level;
            that.edit_cash_warn_info["coin_overflow_warning_level"] =
              rowData.coin_overflow_warning_level;
            that.edit_cash_warn_info["coin_overflow_stop_level"] =
              rowData.coin_overflow_stop_level;
            //零用金資訊
            that.edit_cash_warn_info["store_allowance"]["sub_500_out"] =
              res.data.data.petty_cash_500;
            that.edit_cash_warn_info["store_allowance"]["sub_100_out"] =
              res.data.data.petty_cash_100;
            that.edit_cash_warn_info["store_allowance"]["cycel_50_out"] =
              res.data.data.petty_cash_50;
            that.edit_cash_warn_info["store_allowance"]["cycel_10_out"] =
              res.data.data.petty_cash_10;
            that.edit_cash_warn_info["store_allowance"]["cycel_5_out"] =
              res.data.data.petty_cash_5;
            that.edit_cash_warn_info["store_allowance"]["cycel_1_out"] =
              res.data.data.petty_cash_1;
            //門市資訊
            that.edit_cash_warn_info["store_id"] = rowData.store_id;
            that.edit_cash_warn_info["store_name"] = rowData.store_name;

            that.edit_cash_warn_info["show_store_info"] = true;
            that.edit_cash_warn_info["show_edit_btn"] = true;
            that.edit_cash_warn_info["show"] = true;
            that.$q.loading.hide();
          })
          .catch(async function (err) {
            that.$q.loading.hide();
            console.log(err);
          });
      }
    },

    //	更新
    save_store_cash_warn() {
      let that = this;
      that.$q.loading.show();
      let error_msg = "";
      //	各水位數值驗證
      if (
        that.edit_cash_warn_info.cash_warning_level > 75 ||
        that.edit_cash_warn_info.cash_warning_level < 1
      ) {
        error_msg = `${that.$t(
          "page.store_cash_warn_setting.columns.cash_warning_level"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (
        that.edit_cash_warn_info.cash_stop_level > 75 ||
        that.edit_cash_warn_info.cash_stop_level < 1
      ) {
        error_msg = `${that.$t(
          "page.store_cash_warn_setting.columns.cash_stop_level"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (
        that.edit_cash_warn_info.cash_overflow_warning_level > 100 ||
        that.edit_cash_warn_info.cash_overflow_warning_level < 85
      ) {
        error_msg = `${that.$t(
          "page.store_cash_warn_setting.columns.cash_overflow_warning_level"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (
        that.edit_cash_warn_info.cash_overflow_stop_level > 100 ||
        that.edit_cash_warn_info.cash_overflow_stop_level < 85
      ) {
        error_msg = `${that.$t(
          "page.store_cash_warn_setting.columns.cash_overflow_stop_level"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (
        that.edit_cash_warn_info.coin_low_warning_water_level > 75 ||
        that.edit_cash_warn_info.coin_low_warning_water_level < 1
      ) {
        error_msg = `${that.$t(
          "page.store_cash_warn_setting.columns.coin_warning_water_level"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (
        that.edit_cash_warn_info.coin_low_stop_water_level > 75 ||
        that.edit_cash_warn_info.coin_low_stop_water_level < 1
      ) {
        error_msg = `${that.$t(
          "page.store_cash_warn_setting.columns.coin_stop_water_level"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (
        that.edit_cash_warn_info.coin_overflow_warning_level > 100 ||
        that.edit_cash_warn_info.coin_overflow_warning_level < 85
      ) {
        error_msg = `${that.$t(
          "page.store_cash_warn_setting.columns.coin_overflow_warning_level"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (
        that.edit_cash_warn_info.coin_overflow_stop_level > 100 ||
        that.edit_cash_warn_info.coin_overflow_stop_level < 85
      ) {
        error_msg = `${that.$t(
          "page.store_cash_warn_setting.columns.coin_overflow_stop_level"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (error_msg != "") {
        that.FnNotify(error_msg, "error");
        that.$q.loading.hide();
        return;
      }
      var param = {
        Action: "UpdateCashWarn",
        Datas: {
          store_id: that.edit_cash_warn_info.store_id,
          cash_warning_level: that.edit_cash_warn_info.cash_warning_level,
          cash_stop_level: that.edit_cash_warn_info.cash_stop_level,
          cash_overflow_warning_level:
            that.edit_cash_warn_info.cash_overflow_warning_level,
          cash_overflow_stop_level:
            that.edit_cash_warn_info.cash_overflow_stop_level,
          coin_low_warning_water_level:
            that.edit_cash_warn_info.coin_low_warning_water_level,
          coin_low_stop_water_level: that.edit_cash_warn_info.coin_low_stop_water_level,
          coin_overflow_warning_level:
            that.edit_cash_warn_info.coin_overflow_warning_level,
          coin_overflow_stop_level:
            that.edit_cash_warn_info.coin_overflow_stop_level,
        },
      };
      that
        .FnWebAPIPost(param)
        .then(function (res) {
          let result = res.data.result;
          if (result) {
            that.FnNotify(that.message_alart[0]["value"], "success");
            that.searsh_list();
            that.edit_cash_warn_info["show"] = false;
          } else {
            that.FnNotify(that.message_alart[1]["value"], "error");
            that.searsh_list();
            that.edit_cash_warn_info["show"] = true;
          }
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
