var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_machine_alarm_list",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      search: {
        store: "1",
        start_date: moment().format("YYYY/MM/DD"),
        end_date: moment().format("YYYY/MM/DD"),
      },
      edit_cash_warn_info: {
        show: false, // 編輯零用金版面顯示
        show_edit_btn: false, // 編輯零用金按鈕
        show_delete_btn: false, // 刪除零用金按鈕

        editUserDisable: false, // 編輯那些資料不能更新設定
        store_id: null, //門市編號
        cash_warning_level: null, // 鈔票警告水位
        cash_stop_level: null, // 鈔票即停水位
        cash_overflow_warning_level: null, // 溢幣區(鈔票)警告水位
        cash_overflow_stop_level: null, // 溢幣區(鈔票)停止水位
        coin_warning_water_level: null, // 硬幣警告水位
        coin_stop_water_level: null, // 硬幣停止水位
        coin_overflow_warning_level: null, // 溢幣區(硬幣)警告水位
        coin_overflow_stop_level: null, // 溢幣區(硬幣)停止水位

        enabled: false,
      },
      excel_name: "machine_alarm_list",
    };
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "create_time",
          required: true,
          label: this.$t("page.store_machine_alarm_list.columns.create_time"),
          align: "left",
          field: "create_time",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD HH:mm:ss");
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_id",
          required: true,
          label: this.$t("page.store_machine_alarm_list.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_name",
          required: true,
          label: this.$t("page.store_machine_alarm_list.columns.store_name"),
          align: "left",
          field: "store_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cashier_name",
          required: true,
          label: this.$t("page.store_machine_alarm_list.columns.cashier_name"),
          align: "left",
          field: "cashier_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "alarm_code",
          required: true,
          label: this.$t("page.store_machine_alarm_list.columns.alarm_code"),
          align: "left",
          field: "alarm_code",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "alarm_name",
          required: true,
          label: this.$t("page.store_machine_alarm_list.columns.alarm_name"),
          align: "left",
          field: "alarm_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "alarm_note",
          required: true,
          label: this.$t("page.store_machine_alarm_list.columns.alarm_note"),
          align: "left",
          field: "alarm_note",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //excel 報表匯出 名稱定義
    excel_name_str() {
      let res = "";
      let store = "";
      let that = this;
      if (this.search.store != 0) {
        this.store.forEach(el => {
          if (el.value == that.search.store) {
            store = `_${el.label}`;
          }
        });
      }
      res = `${this.excel_name}ExportExcel${store}`;
      return res;
    }
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      var params = {
        Action: "StoreAlarmList",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
