<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
  // 引用 head.inc
  include_once "html_head.inc";
  ?>
</head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    // include_once "html_menu.inc";
    include_once "html_layout_header.inc";
    ?>
    <!-- 內容區域 //-->
    <data-table :show-search-field="true" :selected.sync="select_store" :show-search-panel="true" :show-download-btn="export_cheak" :columns="columns" :data="tableData" selection="multiple" row-key="store_id" @search-ok="searsh_list()">
      <template v-slot:page-sticky>
        <q-btn color="primary" @click.native="open_allowance_info_multiple()">多選設定</q-btn>
      </template>
      <template v-slot:search-form>
        <div>
          <div class="w3-row-padding">
            <div class="w3-col l4 s6" style="max-width:300px">
              <q-select v-model="search.store" :stack-label="$t('page.store_allowance_setting.search.store')" :options="store" filter />
            </div>
          </div>
        </div>
      </template>

      <template v-slot:row-control="props">
        <q-btn v-if="true" color="primary" :label="$t('sys.setting')" @click.native="edit_store_allowance(props.row_data.row)"></q-btn>
      </template>
    </data-table>
    <!-- /內容區域 //-->

    <template>
      <q-modal v-model="edit_allowance_info['show']" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss :content-css="{minWidth: '10vw', maxHeight: '100vh'}">
        <div class="modal-title">
          <div>
            {{ $t('page.store_allowance_setting.edit_block.edit_title') }}
          </div>
        </div>
        <div class="modal-scroll-box" style="padding:15px; font-weight: 700; font-size:16px">
          <div v-if="edit_allowance_info['show_store_info']" class="row justify-around">
            <div class="col-5" style="margin: 10px;">
              <label v-text="$t('page.store_allowance_setting.edit_block.store_id')"></label>
              <q-input v-model="edit_allowance_info['store_id']" :readonly="true"></q-input>
            </div>
            <div class="col-5" style="margin: 10px;">
              <label v-text="$t('page.store_allowance_setting.edit_block.store_name')"></label>
              <q-input v-model="edit_allowance_info['store_name']" :readonly="true"></q-input>
            </div>
          </div>
          <div style="margin: 10px;">
            <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.total_amount')"></label>
            <q-input v-model="total_amount" :disable="true" :readonly="true"></q-input>
          </div>
          <div class="row">
            <div v-if="false" style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_500')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{edit_allowance_info['cash_500_max']}}</span>
              <q-input v-model="edit_allowance_info['petty_cash_500']" min="0" :max="edit_allowance_info['cash_500_max']" type="number"></q-input>
            </div>
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_100')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{edit_allowance_info['cash_100_max']}}</span>
              <q-input v-model="edit_allowance_info['petty_cash_100']" min="0" :max="edit_allowance_info['cash_100_max']" type="number"></q-input>
            </div>
          </div>
          <div class="row">
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_50')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{edit_allowance_info['cash_50_max']}}</span>
              <q-input v-model="edit_allowance_info['petty_cash_50']" min="0" :max="edit_allowance_info['cash_50_max']" type="number"></q-input>
            </div>
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_10')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{edit_allowance_info['cash_10_max']}}</span>
              <q-input v-model="edit_allowance_info['petty_cash_10']" min="0" :max="edit_allowance_info['cash_10_max']" type="number"></q-input>
            </div>
          </div>
          <div class="row">
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_5')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{edit_allowance_info['cash_5_max']}}</span>
              <q-input v-model="edit_allowance_info['petty_cash_5']" min="0" :max="edit_allowance_info['cash_5_max']" type="number"></q-input>
            </div>
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_1')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{edit_allowance_info['cash_1_max']}}</span>
              <q-input v-model="edit_allowance_info['petty_cash_1']" min="0" :max="edit_allowance_info['cash_1_max']" type="number"></q-input>
            </div>
          </div>
        </div>
        <div style="display:flex; flex-grow: row; justify-content: center;margin: 20px;">
          <q-btn color="primary" :label="$t('sys.update')" class="btn-style2" @click="save_store_allowance()" v-if="edit_allowance_info['show_edit_btn']"></q-btn>
          <q-btn :color="edit_allowance_info['show_edit_btn'] == true ? 'secondary' : 'secondary'" :label="$t('sys.close')" class="btn-style2" @click="cancel_store_allowance()"></q-btn>
        </div>
      </q-modal>
    </template>
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  // loading.inc
  include_once "html_loading.inc";
  ?>
</body>
<?php
$is_report_download = true;
// 引用 down.inc
include_once "html_down.php";
?>

</html>