<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
  // 引用 head.inc
  include_once "html_head.inc";
  ?>
</head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    // include_once "html_menu.inc";
    include_once "html_layout_header.inc";
    ?>
    <!-- 內容區域 //-->
    <data-table :show-search-field="true" :selected.sync="select_store" :show-search-panel="true" :show-download-btn="export_cheak" :columns="columns" :data="tableData" selection="multiple" row-key="store_id" @search-ok="searsh_list()">
      <template v-slot:page-sticky>
        <q-btn color="primary" @click.native="open_edit_store_cash_warn('all')">多選設定</q-btn>
      </template>
      <template v-slot:search-form>
        <div>
          <div class="w3-row-padding">
            <div class="w3-col l4 s6" style="max-width:300px">
              <q-select v-model="search.store" :stack-label="$t('page.store_cash_warn_setting.search.store')" :options="store" filter />
            </div>
          </div>
        </div>
      </template>

      <template v-slot:row-control="props">
        <q-btn v-if="true" color="primary" :label="$t('sys.setting')" @click.native="open_edit_store_cash_warn(props.row_data.row)"></q-btn>
      </template>
    </data-table>
    <!-- /內容區域 //-->

    <template>
      <q-modal v-model="edit_cash_warn_info['show']" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss :content-css="{minWidth: '20vw', maxHeight: '100vh'}">
        <div class="modal-title">
          <div>
            {{ $t('page.store_cash_warn_setting.edit_block.edit_title') }}
          </div>
        </div>
        <div class="modal-scroll-box" style="padding:15px; font-weight: 700; font-size:16px">
          <div v-if="edit_cash_warn_info['show_store_info']" class="row justify-around">
            <div class="col-5" style="margin: 10px;">
              <label v-text="$t('page.store_cash_warn_setting.edit_block.store_id')"></label>
              <q-input v-model="edit_cash_warn_info['store_id']" type="test" readonly></q-input>
            </div>
            <div class="col-5" style="margin: 10px;">
              <label v-text="$t('page.store_cash_warn_setting.edit_block.store_name')"></label>
              <q-input v-model="edit_cash_warn_info['store_name']" type="text" readonly></q-input>
            </div>
          </div>
          <div class="row">
            <div style="margin: 10px;">
              <label class="warning-font" v-text="$t('page.store_cash_warn_setting.edit_block.cash_warning_level')"></label>
              <q-input v-model="edit_cash_warn_info['cash_warning_level']" min="1" max="75" type="number" suffix="%"></q-input>
              <div v-if="edit_cash_warn_info['show_store_info']" class="row justify-start">
                <span class="col leo-input-tips">100元：{{ auto_count.cash_warning_level_100 }} 張</span>
              </div>
            </div>
            <div style="margin: 10px;">
              <label class="stop-font" v-text="$t('page.store_cash_warn_setting.edit_block.cash_stop_level')"></label>
              <q-input v-model="edit_cash_warn_info['cash_stop_level']" min="1" max="75" type="number" suffix="%"></q-input>
              <div v-if="edit_cash_warn_info['show_store_info']" class="row justify-start">
                <span class="col leo-input-tips">100元：{{ auto_count.cash_stop_level_100 }} 張</span>
              </div>
            </div>
          </div>
          <div class="row">
            <div style="margin: 10px;">
              <label class="warning-font" v-text="$t('page.store_cash_warn_setting.edit_block.cash_overflow_warning_level')"></label>
              <q-input v-model="edit_cash_warn_info['cash_overflow_warning_level']" min="85" max="100" type="number" suffix="%"></q-input>
              <span class="leo-input-tips">總張數：{{ auto_count.cash_overflow_warning_level }}</span>
            </div>
            <div style="margin: 10px;">
              <label class="stop-font" v-text="$t('page.store_cash_warn_setting.edit_block.cash_overflow_stop_level')"></label>
              <q-input v-model="edit_cash_warn_info['cash_overflow_stop_level']" min="85" max="100" type="number" suffix="%"></q-input>
              <span class="leo-input-tips">總張數：{{ auto_count.cash_overflow_stop_level }}</span>
            </div>
          </div>
          <div class="row">
            <div style="margin: 10px;">
              <label class="warning-font" v-text="$t('page.store_cash_warn_setting.edit_block.coin_warning_water_level')"></label>
              <q-input v-model="edit_cash_warn_info['coin_low_warning_water_level']" min="1" max="75" type="number" suffix="%"></q-input>
              <div v-if="edit_cash_warn_info['show_store_info']" class="column">
                <div class="row">
                  <span class="col-6 leo-input-tips" style="min-width:100px">50元：{{ auto_count.coin_warning_water_level_50 }} 個</span>
                  <span class="col-6 leo-input-tips" style="min-width:100px">10元：{{ auto_count.coin_warning_water_level_10 }} 個</span>
                </div>
                <div class="row">
                  <span class="col-6 leo-input-tips" style="min-width:100px">5元：{{ auto_count.coin_warning_water_level_5 }} 個</span>
                  <span class="col-6 leo-input-tips" style="min-width:100px">1元：{{ auto_count.coin_warning_water_level_1 }} 個</span>
                </div>
              </div>
            </div>
            <div style="margin: 10px;">
              <label class="stop-font" v-text="$t('page.store_cash_warn_setting.edit_block.coin_stop_water_level')"></label>
              <q-input v-model="edit_cash_warn_info['coin_low_stop_water_level']" min="1" max="75" type="number" suffix="%"></q-input>
              <div v-if="edit_cash_warn_info['show_store_info']" class="column">
                <div class="row justify-around">
                  <span class="col-6 leo-input-tips" style="min-width:100px">50元：{{ auto_count.coin_stop_water_level_50 }} 個</span>
                  <span class="col-6 leo-input-tips" style="min-width:100px">10元：{{ auto_count.coin_stop_water_level_10 }} 個</span>
                </div>
                <div class="row justify-around">
                  <span class="col-6 leo-input-tips" style="min-width:100px">5元：{{ auto_count.coin_stop_water_level_5 }} 個</span>
                  <span class="col-6 leo-input-tips" style="min-width:100px">1元：{{ auto_count.coin_stop_water_level_1 }} 個</span>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div style="margin: 10px;">
              <label class="warning-font" v-text="$t('page.store_cash_warn_setting.edit_block.coin_overflow_warning_level')"></label>
              <q-input v-model="edit_cash_warn_info['coin_overflow_warning_level']" min="85" max="100" type="number" suffix="%"></q-input>
              <div class="column">
                <div class="row justify-around">
                  <span class="col-6 leo-input-tips">50元：{{ auto_count.coin_overflow_warning_level_50 }} 個</span>
                  <span class="col-6 leo-input-tips">10元：{{ auto_count.coin_overflow_warning_level_10 }} 個</span>
                </div>
                <div class="row justify-around">
                  <span class="col-6 leo-input-tips">5元：{{ auto_count.coin_overflow_warning_level_5 }} 個</span>
                  <span class="col-6 leo-input-tips">1元：{{ auto_count.coin_overflow_warning_level_1 }} 個</span>
                </div>
              </div>
            </div>
            <div style="margin: 10px;">
              <label class="stop-font" v-text="$t('page.store_cash_warn_setting.edit_block.coin_overflow_stop_level')"></label>
              <q-input v-model="edit_cash_warn_info['coin_overflow_stop_level']" min="85" max="100" type="number" suffix="%"></q-input>
              <div class="column">
                <div class="row justify-around">
                  <span class="col-6 leo-input-tips">50元：{{ auto_count.coin_overflow_stop_level_50 }} 個</span>
                  <span class="col-6 leo-input-tips">10元：{{ auto_count.coin_overflow_stop_level_10 }} 個</span>
                </div>
                <div class="row justify-around">
                  <span class="col-6 leo-input-tips">5元：{{ auto_count.coin_overflow_stop_level_5 }} 個</span>
                  <span class="col-6 leo-input-tips">1元：{{ auto_count.coin_overflow_stop_level_1 }} 個</span>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div style="display:flex; flex-grow: row; justify-content: center;margin: 20px;">
          <q-btn color="primary" :label="$t('sys.update')" class="btn-style2" @click="save_store_cash_warn()" v-if="edit_cash_warn_info['show_edit_btn']"></q-btn>
          <q-btn :color="edit_cash_warn_info['show_edit_btn'] == true ? 'secondary' : 'secondary'" :label="$t('sys.close')" class="btn-style2" @click="cancel_store_cash_warn()"></q-btn>
        </div>
      </q-modal>
    </template>
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  // loading.inc
  include_once "html_loading.inc";
  ?>
</body>
<?php
$is_report_download = true;
// 引用 down.inc
include_once "html_down.php";
?>

</html>