<?php
/* 各API 需有 token_verify() token驗證function ，因各API撈取API金鑰方式不同*/
class WebAPIForMenuPage extends base_class
{


    /**
     * Leo
     * 新增貨幣異動
     */
    public function Create_currency_changes($params)
    {
        //設定寫入資料
        $s_cashier_id = (string) $params["cashier"];
        $s_create_at = (string) $params["create_at"];
        //循環箱 異動數量
        $n_cycle_box_500 = (int) $params["cycle_500"];
        $n_cycle_box_100 = (int) $params["cycle_100"];
        $n_cycle_box_50 = (int) $params["cycle_50"];
        $n_cycle_box_10 = (int) $params["cycle_10"];
        $n_cycle_box_5 = (int) $params["cycle_5"];
        $n_cycle_box_1 = (int) $params["cycle_1"];
        //保全箱 異動數量
        $n_safe_box_1000 = (int) $params["safe_1000"]; //循環箱1000會直接入保全箱
        $n_safe_box_500 = (int) $params["safe_500"];
        $n_safe_box_100 = (int) $params["safe_100"];
        $n_safe_box_50 = (int) $params["safe_50"];
        $n_safe_box_10 = (int) $params["safe_10"];
        $n_safe_box_5 = (int) $params["safe_5"];
        $n_safe_box_1 = (int) $params["safe_1"];
        //備用出鈔機 異動數量
        $n_sub_500_out = (int) $params["sub_500_out"];
        $n_sub_100_out = (int) $params["sub_100_out"];
        //備用入鈔機 異動數量
        $n_sub_1000_in = (int) $params["sub_1000_in"];
        $n_sub_500_in = (int) $params["sub_500_in"];
        $n_sub_100_in = (int) $params["sub_100_in"];
        //操作類型 1.溢幣 2. 純補入 3.換補(收款) 4.無交易貨幣異動(機台測試或其他操作)
        $n_operate_type = 4;

        //先查詢門市資訊
        $sql = sprintf(
            "SELECT 
                    _c.store_id
			FROM 	
				[%s].[dbo].[cashier] AS _c 
			WHERE
                _c.cashier_id = :cashier_id
			",
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "cashier_id" => $s_cashier_id
        ]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        if (empty($row)) { // 門市存在與否判斷
            throw new Exception("store 異常", 20);
        }
        $n_store_id = $row["store_id"];

        //設定寫入資料
        $a_insert_arr = [
            "cashier_id" => $s_cashier_id,
            "store_id" => $n_store_id,
            "create_at" => $s_create_at,
            "safe_box_1000" => $n_safe_box_1000,
            "safe_box_500" => $n_safe_box_500,
            "safe_box_100" => $n_safe_box_100,
            "safe_box_50" => $n_safe_box_50,
            "safe_box_10" => $n_safe_box_10,
            "safe_box_5" => $n_safe_box_5,
            "safe_box_1" => $n_safe_box_1,
            "cycle_box_500" => $n_cycle_box_500,
            "cycle_box_100" => $n_cycle_box_100,
            "cycle_box_50" => $n_cycle_box_50,
            "cycle_box_10" => $n_cycle_box_10,
            "cycle_box_5" => $n_cycle_box_5,
            "cycle_box_1" => $n_cycle_box_1,
            "sub_500_out" => $n_sub_500_out,
            "sub_100_out" => $n_sub_100_out,
            "sub_1000_in" => $n_sub_1000_in,
            "sub_500_in" => $n_sub_500_in,
            "sub_100_in" => $n_sub_100_in,
            "operate_type" => $n_operate_type,
        ];
        //拼接sql字串
        $sql = sprintf(
            "INSERT INTO [%s].[dbo].[cashier_currency_statement](
                cashier_id,
                store_id,
                create_at,
                safe_box_1000,
                safe_box_500,
                safe_box_100,
                safe_box_50,
                safe_box_10,
                safe_box_5,
                safe_box_1,
                cycle_box_500,
                cycle_box_100,
                cycle_box_50,
                cycle_box_10,
                cycle_box_5,
                cycle_box_1,
                sub_500_out,
                sub_100_out ,
                sub_1000_in,
                sub_500_in ,
                sub_100_in,
                operate_type
            )
            VALUES
            (
                :cashier_id,
                :store_id,
                :create_at,
                :safe_box_1000,
                :safe_box_500,
                :safe_box_100,
                :safe_box_50,
                :safe_box_10,
                :safe_box_5,
                :safe_box_1,
                :cycle_box_500,
                :cycle_box_100,
                :cycle_box_50,
                :cycle_box_10,
                :cycle_box_5,
                :cycle_box_1,
                :sub_500_out,
                :sub_100_out ,
                :sub_1000_in,
                :sub_500_in ,
                :sub_100_in,
                :operate_type
            )
			",
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute($a_insert_arr);

        return "OK";
    }
    /**
     * Leo
     * api 驗證
     */
    public function api_verify($token, $params)
    {
        //門市編號
        $n_store_id = (int) $params["store"];
        if ($n_store_id == 0) { //門市編號為空
            throw new Exception("store 欄位不可為空", 91000);
        } else {    //檢查門市是否存在
            $sql = sprintf(
                "SELECT 
                        _s.store_id
                FROM 	
                    [%s].[dbo].[store] AS _s 
                WHERE
                    _s.store_id = :store_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "store_id" => $n_store_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("store 異常", 91000);
            }
        }
        //機台序號
        $s_cashier_id = (string) $params["cashier"];
        if ($s_cashier_id == "") { //機台編號為空
            throw new Exception("cashier 欄位不可為空", 91000);
        } else { //檢查機台是否存在
            $sql = sprintf(
                "SELECT 
                        _c.cashier_id
                FROM 	
                    [%s].[dbo].[cashier] AS _c
                WHERE
                    _c.cashier_id = :cashier_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "cashier_id" => $s_cashier_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("cashier error", 91000);
            }
        }
        //時間戳(單位秒)
        $s_send_at = (string) $params["send_at"];
        if ($s_send_at == "") { //時間戳為空
            throw new Exception("send_at 欄位不可為空", 91000);
        } else if ($this->check_timestamp_format($s_send_at) != true) {
            throw new Exception("send_at format error", 91000);
        }
        //Token
        if (trim($token) == "") { //Token為空
            throw new Exception("token 欄位不可為空", 91000);
        }
        /*循環機(主鈔機、硬幣機) */
        //紙鈔循環機-500
        if (!isset($params["cycle_500"])) { // 循環機-500為空
            throw new Exception("cycle_500 欄位不可為空", 91000);
        }
        //紙鈔循環機-100
        if (!isset($params["cycle_100"])) { // 循環機-100為空
            throw new Exception("cycle_100 欄位不可為空", 91000);
        }
        //硬幣循環機-50
        if (!isset($params["cycle_50"])) { // 循環機-50為空
            throw new Exception("cycle_50 欄位不可為空", 91000);
        }
        //硬幣循環機-10
        if (!isset($params["cycle_10"])) { // 循環機-10為空
            throw new Exception("cycle_10 欄位不可為空", 91000);
        }
        //硬幣循環機-5
        if (!isset($params["cycle_5"])) { // 循環機-5為空
            throw new Exception("cycle_5 欄位不可為空", 91000);
        }
        //硬幣循環機-1
        if (!isset($params["cycle_1"])) { // 循環機-1為空
            throw new Exception("cycle_1 欄位不可為空", 91000);
        }

        /*循環機保全箱(主鈔機、硬幣機) */
        //紙鈔保全箱-1000
        if (!isset($params["safe_1000"])) { // 保全箱-1000為空
            throw new Exception("safe_1000 欄位不可為空", 91000);
        }
        //紙鈔保全箱-500
        if (!isset($params["safe_500"])) { // 保全箱-500為空
            throw new Exception("safe_500 欄位不可為空", 91000);
        }
        //紙鈔保全箱-100
        if (!isset($params["safe_100"])) { // 保全箱-100為空
            throw new Exception("safe_100 欄位不可為空", 91000);
        }
        //硬幣保全箱-50
        if (!isset($params["safe_50"])) { // 保全箱-50為空
            throw new Exception("safe_50 欄位不可為空", 91000);
        }
        //硬幣保全箱-10
        if (!isset($params["safe_10"])) { // 保全箱-10為空
            throw new Exception("safe_10 欄位不可為空", 91000);
        }
        //硬幣保全箱-5
        if (!isset($params["safe_5"])) { // 保全箱-5為空
            throw new Exception("safe_5 欄位不可為空", 91000);
        }
        //硬幣保全箱-1
        if (!isset($params["safe_1"])) { // 保全箱-1為空
            throw new Exception("safe_1 欄位不可為空", 91000);
        }


        /*備用出鈔機(LCDM) */
        //備用出鈔機-500
        if (!isset($params["sub_500_out"])) { // 備用出鈔機-500為空
            throw new Exception("sub_500_out 欄位不可為空", 91000);
        }
        //備用出鈔機-100
        if (!isset($params["sub_100_out"])) { // 備用出鈔機-100為空
            throw new Exception("sub_100_out 欄位不可為空", 91000);
        }

        /*備用入鈔機(TP70) */
        //備用入鈔機-500
        if (!isset($params["sub_1000_in"])) { // 備用入鈔機-500為空
            throw new Exception("sub_1000_in 欄位不可為空", 91000);
        }
        //備用入鈔機-100
        if (!isset($params["sub_500_in"])) { // 備用入鈔機-100為空
            throw new Exception("sub_500_in 欄位不可為空", 91000);
        }
        //備用鈔機-100
        if (!isset($params["sub_100_in"])) { // 備用入鈔機-100為空
            throw new Exception("sub_100_in 欄位不可為空", 91000);
        }

        //建立時間
        $s_create_at = (string) $params["create_at"];
        if ($s_create_at == "") { // 建立時間為空
            throw new Exception("create_at 欄位不可為空", 91000);
        } else if ($this->check_date_format($s_create_at) != true) { //時間格式不正確
            throw new Exception("create_at 時間格式不正確", 91000);
        }


        //依據資料查詢門市API金鑰來進行Token驗證
        $sql = sprintf(
            "SELECT 
                    _s.store_api_key,
                    _c.cashier_id
            FROM 	
                 [%s].[dbo].[cashier] AS _c
                 LEFT JOIN [%s].[dbo].[store] AS _s ON _s.store_id = _c.store_id
            WHERE
                _c.store_id = :store_id AND
                _c.cashier_id = :cashier_id",
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "store_id" => $n_store_id,
            "cashier_id" => $s_cashier_id
        ]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        if (!empty($row)) {
            $s_api_key = $row["store_api_key"];
            if ($this->shopee_api_token_verify($token, $s_api_key, $s_send_at) != true) {
                throw new Exception("Token Verification Failed", 91001);
            }
        } else {
            //查詢不到該門市該機台
            throw new Exception("store and cashier not binding", 91000);
        }
        //更新最後連線時間
        $this->cashier_connect_time_update($n_store_id, $s_cashier_id, $s_send_at);
    }
}
