<?php
/* 各API 需有 token_verify() token驗證function ，因各API撈取API金鑰方式不同*/
class WebAPIForMenuPage extends base_class
{


    /**
     * Leo
     * 新增溢幣資料
     */
    public function Create_currency_overflow($params)
    {
        //設定寫入資料
        $s_cashier_id = (string) $params["cashier"];
        $s_create_at = (string) $params["create_at"];
        //溢幣的話保全箱資料一定是入鈔、入幣動作
        $n_safe_box_500 = (int) $params["overflow_500"];
        $n_safe_box_100 = (int) $params["overflow_100"];
        $n_safe_box_50 = (int) $params["overflow_50"];
        $n_safe_box_10 = (int) $params["overflow_10"];
        $n_safe_box_5 = (int) $params["overflow_5"];
        $n_safe_box_1 = (int) $params["overflow_1"];
        //溢幣的話循環箱資料一定是出鈔、出幣動作(因為進入保全箱)
        $n_cycle_box_500 = bcmul($n_safe_box_500, '-1', 0);
        $n_cycle_box_100 = bcmul($n_safe_box_100, '-1', 0);
        $n_cycle_box_50 = bcmul($n_safe_box_50, '-1', 0);
        $n_cycle_box_10 = bcmul($n_safe_box_10, '-1', 0);
        $n_cycle_box_5 = bcmul($n_safe_box_5, '-1', 0);
        $n_cycle_box_1 = bcmul($n_safe_box_1, '-1', 0);
        $n_operate_type = 1; //操作類型 1.溢幣 2. 純補入 3.換補(收款) 4.無交易貨幣異動(機台測試或其他操作)

        //先查詢門市資訊
        $sql = sprintf(
            "SELECT 
                    _c.store_id
			FROM 	
				[%s].[dbo].[cashier] AS _c 
			WHERE
                _c.cashier_id = :cashier_id
			",
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "cashier_id" => $s_cashier_id
        ]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        if (empty($row)) { // 門市存在與否判斷
            throw new Exception("store 異常", 20);
        }
        $n_store_id = $row["store_id"];

        //設定寫入資料
        $a_insert_arr = [
            "cashier_id" => $s_cashier_id,
            "store_id" => $n_store_id,
            "create_at" => $s_create_at,
            "safe_box_500" => $n_safe_box_500,
            "safe_box_100" => $n_safe_box_100,
            "safe_box_50" => $n_safe_box_50,
            "safe_box_10" => $n_safe_box_10,
            "safe_box_5" => $n_safe_box_5,
            "safe_box_1" => $n_safe_box_1,
            "cycle_box_500" => $n_cycle_box_500,
            "cycle_box_100" => $n_cycle_box_100,
            "cycle_box_50" => $n_cycle_box_50,
            "cycle_box_10" => $n_cycle_box_10,
            "cycle_box_5" => $n_cycle_box_5,
            "cycle_box_1" => $n_cycle_box_1,
            "operate_type" => $n_operate_type,
        ];
        //拼接sql字串
        $sql = sprintf(
            "INSERT INTO [%s].[dbo].[cashier_currency_statement](
                cashier_id,
                store_id,
                create_at,
                safe_box_500,
                safe_box_100,
                safe_box_50,
                safe_box_10,
                safe_box_5,
                safe_box_1,
                cycle_box_500,
                cycle_box_100,
                cycle_box_50,
                cycle_box_10,
                cycle_box_5,
                cycle_box_1,
                operate_type
            )
            VALUES
            (
                :cashier_id,
                :store_id,
                :create_at,
                :safe_box_500,
                :safe_box_100,
                :safe_box_50,
                :safe_box_10,
                :safe_box_5,
                :safe_box_1,
                :cycle_box_500,
                :cycle_box_100,
                :cycle_box_50,
                :cycle_box_10,
                :cycle_box_5,
                :cycle_box_1,
                :operate_type
            )
			",
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute($a_insert_arr);

        return "OK";
    }
    /**
     * Leo
     * api 驗證
     */
    public function api_verify($token, $params)
    {
        //門市編號
        $n_store_id = (int) $params["store"];
        if ($n_store_id == 0) { //門市編號為空
            throw new Exception("store 欄位不可為空", 91000);
        } else {    //檢查門市是否存在
            $sql = sprintf(
                "SELECT 
                        _s.store_id
                FROM 	
                    [%s].[dbo].[store] AS _s 
                WHERE
                    _s.store_id = :store_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "store_id" => $n_store_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("store 異常", 91000);
            }
        }
        //機台序號
        $s_cashier_id = (string) $params["cashier"];
        if ($s_cashier_id == "") { //機台編號為空
            throw new Exception("cashier 欄位不可為空", 91000);
        } else { //檢查機台是否存在
            $sql = sprintf(
                "SELECT 
                        _c.cashier_id
                FROM 	
                    [%s].[dbo].[cashier] AS _c
                WHERE
                    _c.cashier_id = :cashier_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "cashier_id" => $s_cashier_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("cashier error", 91000);
            }
        }
        //時間戳(單位秒)
        $s_send_at = (string) $params["send_at"];
        if ($s_send_at == "") { //時間戳為空
            throw new Exception("send_at 欄位不可為空", 91000);
        } else if ($this->check_timestamp_format($s_send_at) != true) {
            throw new Exception("send_at format error", 91000);
        }
        //Token
        if (trim($token) == "") { //Token為空
            throw new Exception("token 欄位不可為空", 91000);
        }
        //溢幣數量-500
        $n_overflow_500 = (int) $params["overflow_500"];
        if (!isset($params["overflow_500"])) { // 溢幣數量-500為空
            throw new Exception("overflow_500 欄位不可為空", 91000);
        } else if ($n_overflow_500 < 0) {
            throw new Exception("overflow_500 Cannot be negative");
        }
        //溢幣數量-100
        $n_overflow_100 = (int) $params["overflow_100"];
        if (!isset($params["overflow_100"])) { // 溢幣數量-100為空
            throw new Exception("overflow_100 欄位不可為空", 91000);
        } else if ($n_overflow_100 < 0) {
            throw new Exception("overflow_100 Cannot be negative");
        }
        //溢幣數量-50
        $n_overflow_50 = (int) $params["overflow_50"];
        if (!isset($params["overflow_50"])) { // 溢幣數量-50為空
            throw new Exception("overflow_50 欄位不可為空", 91000);
        } else if ($n_overflow_50 < 0) {
            throw new Exception("overflow_50 Cannot be negative");
        }
        //溢幣數量-10
        $n_overflow_10 = (int) $params["overflow_10"];
        if (!isset($params["overflow_10"])) { // 溢幣數量-10為空
            throw new Exception("overflow_10 欄位不可為空", 91000);
        } else if ($n_overflow_10 < 0) {
            throw new Exception("overflow_10 Cannot be negative");
        }
        //溢幣數量-5
        $n_overflow_5 = (int) $params["overflow_5"];
        if (!isset($params["overflow_5"])) { // 溢幣數量-5為空
            throw new Exception("overflow_5 欄位不可為空", 91000);
        } else if ($n_overflow_5 < 0) {
            throw new Exception("overflow_5 Cannot be negative");
        }
        //溢幣數量-1
        $n_overflow_1 = (int) $params["overflow_1"];
        if (!isset($params["overflow_1"])) { // 溢幣數量-1為空
            throw new Exception("overflow_1 欄位不可為空", 91000);
        } else if ($n_overflow_1 < 0) {
            throw new Exception("overflow_1 Cannot be negative");
        }
        //建立時間
        $s_create_at = (string) $params["create_at"];
        if ($s_create_at == "") { // 建立時間為空
            throw new Exception("create_at 欄位不可為空", 91000);
        } else if ($this->check_date_format($s_create_at) != true) { //時間格式不正確
            throw new Exception("create_at 時間格式不正確", 91000);
        }


        //依據資料查詢門市API金鑰來進行Token驗證
        $sql = sprintf(
            "SELECT 
                    _s.store_api_key,
                    _c.cashier_id
            FROM 	
                 [%s].[dbo].[cashier] AS _c
                 LEFT JOIN [%s].[dbo].[store] AS _s ON _s.store_id = _c.store_id
            WHERE
                _c.store_id = :store_id AND
                _c.cashier_id = :cashier_id",
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "store_id" => $n_store_id,
            "cashier_id" => $s_cashier_id
        ]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        if (!empty($row)) {
            $s_api_key = $row["store_api_key"];
            if ($this->shopee_api_token_verify($token, $s_api_key, $s_send_at) != true) {
                throw new Exception("Token Verification Failed", 91001);
            }
        } else {
            //查詢不到該門市該機台
            throw new Exception("store and cashier not binding", 91000);
        }
        //更新最後連線時間
        $this->cashier_connect_time_update($n_store_id, $s_cashier_id, $s_send_at);
    }
}
