<?php
/* 各API 需有 token_verify() token驗證function ，因各API撈取API金鑰方式不同*/
class WebAPIForMenuPage extends base_class
{


    /**
     * Leo
     * 新增物流交易(失敗的)資料
     */
    public function Create_transaction_fail($params)
    {
        #設定寫入資料

        //門市機台編號
        $s_cashier_id = (string) $params["cashier"];
        //蝦皮訂單編號
        $s_shopee_order_id = (string) $params["order_id"];
        //蝦皮出貨任務編號
        $s_shopee_shipment_id = (string) $params["shipment_id"];
        //付款方式
        $s_payment_type = (string) $params["payment_type"];
        $n_order_amount = (int) $params["amount"];
        $s_trading_status = (string) $params["trading_status"];
        $s_transaction_start_time = (string) $params["start_at"];
        $s_transaction_end_time = (string) $params["end_at"];
        //拒鈔次數
        $n_reject_cash_count = (int) $params["reject_cash"];
        //循環機入鈔
        $n_cash_1000_in = (int) $params["cash_1000_in"];
        $n_cash_500_in = (int) $params["cash_500_in"];
        $n_cash_100_in = (int) $params["cash_100_in"];
        //硬幣機入幣
        $n_cash_50_in = (int) $params["cash_50_in"];
        $n_cash_10_in = (int) $params["cash_10_in"];
        $n_cash_5_in = (int) $params["cash_5_in"];
        $n_cash_1_in = (int) $params["cash_1_in"];
        //循環機出鈔
        $n_cash_500_out = (int) $params["cash_500_out"];
        $n_cash_100_out = (int) $params["cash_100_out"];
        //硬幣機出幣
        $n_cash_50_out = (int) $params["cash_50_out"];
        $n_cash_10_out = (int) $params["cash_10_out"];
        $n_cash_5_out = (int) $params["cash_5_out"];
        $n_cash_1_out = (int) $params["cash_1_out"];
        //TP70入鈔機
        $n_sub_cash_1000_in = (int) $params["sub_1000_in"];
        $n_sub_cash_500_in = (int) $params["sub_500_in"];
        $n_sub_cash_100_in = (int) $params["sub_100_in"];
        //LCDM出鈔機
        $n_sub_cash_500_out = (int) $params["sub_500_out"];
        $n_sub_cash_100_out = (int) $params["sub_100_out"];

        //先查詢門市資訊
        $sql = sprintf(
            "SELECT 
                    _c.store_id
			FROM 	
				[%s].[dbo].[cashier] AS _c 
			WHERE
                _c.cashier_id = :cashier_id
			",
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "cashier_id" => $s_cashier_id
        ]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        if (empty($row)) { // 門市存在與否判斷
            throw new Exception("store 異常", 20);
        }
        $n_store_id = $row["store_id"];
        //訂單建立時間
        $d_create_at = date("Y-m-d H:i:s");
        //建立訂單編號
        $s_trading_id = $this->CreateTimeStampMillisecond() . $n_store_id;
        //設定寫入資料
        $a_insert_arr = [
            "store_id" => $n_store_id,
            "cashier_id" => $s_cashier_id,
            "trading_id" => $s_trading_id,
            "shopee_order_id" => $s_shopee_order_id,
            "shopee_shipment_id" => $s_shopee_shipment_id,
            "payment_type" => $s_payment_type,
            "order_amount" => $n_order_amount,
            "trading_status" => $s_trading_status,
            "transaction_start_at" => $s_transaction_start_time,
            "transaction_end_at" => $s_transaction_end_time,
            "cash_1000_in" => $n_cash_1000_in,
            "cash_500_in" => $n_cash_500_in,
            "cash_100_in" => $n_cash_100_in,
            "cash_50_in" => $n_cash_50_in,
            "cash_10_in" => $n_cash_10_in,
            "cash_5_in" => $n_cash_5_in,
            "cash_1_in" => $n_cash_1_in,
            "cash_500_out" => $n_cash_500_out,
            "cash_100_out" => $n_cash_100_out,
            "cash_50_out" => $n_cash_50_out,
            "cash_10_out" => $n_cash_10_out,
            "cash_5_out" => $n_cash_5_out,
            "cash_1_out" => $n_cash_1_out,
            "reject_cash_count" => $n_reject_cash_count,
            "sub_1000_in" => $n_sub_cash_1000_in,
            "sub_500_in" => $n_sub_cash_500_in,
            "sub_100_in" => $n_sub_cash_100_in,
            "sub_500_out" => $n_sub_cash_500_out,
            "sub_100_out" => $n_sub_cash_100_out,
            "create_at" => $d_create_at,
        ];
        //拼接sql字串
        $sql = sprintf(
            "INSERT INTO [%s].[dbo].[store_transaction_fail](
                store_id,
                cashier_id,
                trading_id,
                shopee_order_id,
                shopee_shipment_id,
                payment_type,
                order_amount,
                trading_status,
                transaction_start_at,
                transaction_end_at,
                cash_1000_in,
                cash_500_in,
                cash_100_in,
                cash_50_in,
                cash_10_in,
                cash_5_in,
                cash_1_in,
                cash_500_out,
                cash_100_out,
                cash_50_out,
                cash_10_out,
                cash_5_out,
                cash_1_out,
                reject_cash_count,
                sub_1000_in,
                sub_500_in,
                sub_100_in,
                sub_500_out,
                sub_100_out,
                create_at
            )
            VALUES
            (
                :store_id,
                :cashier_id,
                :trading_id,
                :shopee_order_id,
                :shopee_shipment_id,
                :payment_type,
                :order_amount,
                :trading_status,
                :transaction_start_at,
                :transaction_end_at,
                :cash_1000_in,
                :cash_500_in,
                :cash_100_in,
                :cash_50_in,
                :cash_10_in,
                :cash_5_in,
                :cash_1_in,
                :cash_500_out,
                :cash_100_out,
                :cash_50_out,
                :cash_10_out,
                :cash_5_out,
                :cash_1_out,
                :reject_cash_count,
                :sub_1000_in,
                :sub_500_in,
                :sub_100_in,
                :sub_500_out,
                :sub_100_out,
                :create_at
            )
			",
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute($a_insert_arr);

        return "OK";
    }
    /**
     * Leo
     * api 驗證
     */
    public function api_verify($token, $params)
    {
        //門市編號
        $n_store_id = (int) $params["store"];
        if ($n_store_id == 0) { //門市編號為空
            throw new Exception("store 欄位不可為空", 91000);
        } else {    //檢查門市是否存在
            $sql = sprintf(
                "SELECT 
                        _s.store_id
                FROM 	
                    [%s].[dbo].[store] AS _s 
                WHERE
                    _s.store_id = :store_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "store_id" => $n_store_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("store 異常", 91000);
            }
        }
        //機台序號
        $s_cashier_id = (string) $params["cashier"];
        if ($s_cashier_id == "") { //機台編號為空
            throw new Exception("cashier 欄位不可為空", 91000);
        } else { //檢查機台是否存在
            $sql = sprintf(
                "SELECT 
                        _c.cashier_id
                FROM 	
                    [%s].[dbo].[cashier] AS _c
                WHERE
                    _c.cashier_id = :cashier_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "cashier_id" => $s_cashier_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("cashier error", 91000);
            }
        }
        //時間戳(單位秒)
        $s_send_at = (string) $params["send_at"];
        if ($s_send_at == "") { //時間戳為空
            throw new Exception("send_at 欄位不可為空", 91000);
        } else if ($this->check_timestamp_format($s_send_at) != true) {
            throw new Exception("send_at format error", 91000);
        }
        //Token
        if (trim($token) == "") { //Token為空
            throw new Exception("token 欄位不可為空", 91000);
        }
        //蝦皮訂單編號
        $s_order_id = (string) $params["order_id"];
        if ($s_order_id == "") { // 蝦皮訂單編號為空
            throw new Exception("order_id 欄位不可為空", 91000);
        }
        //蝦皮訂單編號
        $s_order_id = (string) $params["order_id"];
        if ($s_order_id == "") { // 蝦皮訂單編號為空
            throw new Exception("order_id 欄位不可為空", 91000);
        }
        //蝦皮出貨任務編號
        $s_shipment_id = (string) $params["shipment_id"];
        if ($s_shipment_id == "") { // 蝦皮出貨任務編號為空
            throw new Exception("shipment_id 欄位不可為空", 91000);
        }
        //訂單金額
        if (!isset($params["amount"])) { // 訂單金額為空
            throw new Exception("amount 欄位不可為空", 91000);
        }
        //交易狀態
        $s_trading_status = (string) $params["trading_status"];
        if ($s_trading_status == "") { // 交易狀態為空
            throw new Exception("trading_status 欄位不可為空", 91000);
        }
        //鈔票拒收次數
        $n_reject_cash = (int) $params["reject_cash"];
        if (!isset($params["trading_status"])) { // 鈔票拒收次數為空
            throw new Exception("trading_status 欄位不可為空", 91000);
        } else if ($n_reject_cash < 0) {
            throw new Exception("reject_cash 不可為負數");
        }
        //SCR循環機 入鈔數量-1000
        $n_cash_1000_in = (int) $params["cash_1000_in"];
        if (!isset($params["cash_1000_in"])) { // 入鈔數量-1000為空
            throw new Exception("cash_1000_in 欄位不可為空", 91000);
        }
        //SCR循環機 入鈔數量-500
        $n_cash_500_in = (int) $params["cash_500_in"];
        if (!isset($params["cash_500_in"])) { // 入鈔數量-500為空
            throw new Exception("cash_500_in 欄位不可為空", 91000);
        } 
        //SCR循環機 入鈔數量-100
        $n_cash_100_in = (int) $params["cash_100_in"];
        if (!isset($params["cash_100_in"])) { // 入鈔數量-100為空
            throw new Exception("cash_100_in 欄位不可為空", 91000);
        }
        //SCR循環機 入鈔數量-50
        $n_cash_50_in = (int) $params["cash_50_in"];
        if (!isset($params["cash_50_in"])) { // 入鈔數量-50為空
            throw new Exception("cash_50_in 欄位不可為空", 91000);
        } 
        //SCR循環機 入鈔數量-10
        $n_cash_10_in = (int) $params["cash_10_in"];
        if (!isset($params["cash_10_in"])) { // 入鈔數量-10為空
            throw new Exception("cash_10_in 欄位不可為空", 91000);
        } 
        //SCR循環機 入鈔數量-5
        $n_cash_5_in = (int) $params["cash_5_in"];
        if (!isset($params["cash_5_in"])) { // 入鈔數量-5為空
            throw new Exception("cash_5_in 欄位不可為空", 91000);
        }
        //SCR循環機 入鈔數量-1
        $n_cash_1_in = (int) $params["cash_1_in"];
        if (!isset($params["cash_1_in"])) { // 入鈔數量-1為空
            throw new Exception("cash_1_in 欄位不可為空", 91000);
        } 
        //SCR循環機 出鈔數量-500
        $n_cash_500_out = (int) $params["cash_500_out"];
        if (!isset($params["cash_500_out"])) { // 出鈔數量-500為空
            throw new Exception("cash_500_out 欄位不可為空", 91000);
        } 
        //SCR循環機 出鈔數量-100
        $n_cash_100_out = (int) $params["cash_100_out"];
        if (!isset($params["cash_100_out"])) { // 出鈔數量-100為空
            throw new Exception("cash_100_out 欄位不可為空", 91000);
        } 
        //SCR循環機 出鈔數量-50
        $n_cash_50_out = (int) $params["cash_50_out"];
        if (!isset($params["cash_50_out"])) { // 出鈔數量-50為空
            throw new Exception("cash_50_out 欄位不可為空", 91000);
        } 
        //SCR循環機 出鈔數量-10
        $n_cash_10_out = (int) $params["cash_10_out"];
        if (!isset($params["cash_10_out"])) { // 出鈔數量-10為空
            throw new Exception("cash_10_out 欄位不可為空", 91000);
        } 
        //SCR循環機 出鈔數量-5
        $n_cash_5_out = (int) $params["cash_5_out"];
        if (!isset($params["cash_5_out"])) { // 出鈔數量-5為空
            throw new Exception("cash_5_out 欄位不可為空", 91000);
        } 
        //SCR循環機 出鈔數量-1
        $n_cash_1_out = (int) $params["cash_1_out"];
        if (!isset($params["cash_1_out"])) { // 出鈔數量-1為空
            throw new Exception("cash_1_out 欄位不可為空", 91000);
        } 

        //TP70入鈔機 入鈔數量-1000
        $n_sub_cash_1000_in = (int) $params["sub_1000_in"];
        if (!isset($params["sub_1000_in"])) { // TP70入鈔機 入鈔數量-1000 為空
            throw new Exception("sub_1000_in 欄位不可為空", 91000);
        } 
        //TP70入鈔機 入鈔數量-500
        $n_sub_cash_500_in = (int) $params["sub_500_in"];
        if (!isset($params["sub_500_in"])) { // TP70入鈔機 入鈔數量-500 為空
            throw new Exception("sub_500_in 欄位不可為空", 91000);
        } 
        //TP70入鈔機 入鈔數量-100
        $n_sub_cash_100_in = (int) $params["sub_100_in"];
        if (!isset($params["sub_100_in"])) { // TP70入鈔機 入鈔數量-100 為空
            throw new Exception("sub_100_in 欄位不可為空", 91000);
        } 
        //LCDM出鈔機 出鈔數量-500
        $n_sub_cash_500_out = (int) $params["sub_500_out"];
        if (!isset($params["sub_500_out"])) { // LCDM出鈔機 出鈔數量-500 為空
            throw new Exception("sub_500_out 欄位不可為空", 91000);
        } 
        //LCDM出鈔機 出鈔數量-100
        $n_sub_cash_100_out = (int) $params["sub_100_out"];
        if (!isset($params["sub_100_out"])) { // LCDM出鈔機 出鈔數量-100 為空
            throw new Exception("sub_100_out 欄位不可為空", 91000);
        } 
        //交易開始時間
        $s_start_at = (string) $params["start_at"];
        if ($s_start_at == "") { // 交易開始時間為空
            throw new Exception("start_at 欄位不可為空", 91000);
        } else if ($this->check_date_format($s_start_at) != true) { //時間格式不正確
            throw new Exception("start_at format error", 91000);
        }

        //交易結束時間
        $s_end_at = (string) $params["end_at"];
        if ($s_end_at == "") { // 交易結束時間為空
            throw new Exception("end_at 欄位不可為空", 91000);
        } else if ($this->check_date_format($s_end_at) != true) { //時間格式不正確
            throw new Exception("end_at 時間格式不正確", 91000);
        }



        //依據資料查詢門市API金鑰來進行Token驗證
        $sql = sprintf(
            "SELECT 
                    _s.store_api_key,
                    _c.cashier_id
            FROM 	
                 [%s].[dbo].[cashier] AS _c
                 LEFT JOIN [%s].[dbo].[store] AS _s ON _s.store_id = _c.store_id
            WHERE
                _c.store_id = :store_id AND
                _c.cashier_id = :cashier_id",
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "store_id" => $n_store_id,
            "cashier_id" => $s_cashier_id
        ]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        if (!empty($row)) {
            $s_api_key = $row["store_api_key"];
            if ($this->shopee_api_token_verify($token, $s_api_key, $s_send_at) != true) {
                throw new Exception("Token Verification Failed", 91001);
            }
        } else {
            //查詢不到該門市該機台
            throw new Exception("store and cashier not binding", 91000);
        }
        //更新最後連線時間
        $this->cashier_connect_time_update($n_store_id, $s_cashier_id, $s_send_at);
    }
}
