var $$mixins_common = {
  data() {
    return {
      VarMenuPage: "", // 目前頁面的程式名稱(影響選單與權限等..., 若不指定則抓URL, 如: index.php => index)
      VarIsRequiredLogin: true, // 是否需要登入才能使用
    };
  },
  beforeMount() {
    // 沒有指定則抓URL, 如: index.php => index
    if (this.VarMenuPage == "") {
      var _url = new URL(location.href);
      var _path = _url.pathname.split("/");
      var _now = strip_extension(basename(_path.slice(-1)[0] || "index.php"));
      this.VarMenuPage = _now;
    }
  },
  methods: {
    // 檢查登入者是否為此角色
    FnChkLoginRole(roleKey) {
      try {
        return _.includes(this.LoginSetup.roles, roleKey);
      } catch (e) {
        console.log("FnChkLoginRole() error => " + JSON.stringify(e));
        return false;
      }
    },
    // 檢查登入者是否使用當前頁面的相關功能
    FnChkPageFunction(func) {
      var _token = this.WebStorage.get("sunware_token");
      var _datas = _token ? jwt_decode(_token) : {};
      if (_datas.page_function[this.VarMenuPage].indexOf(func) >= 0) {
        return true;
      } else {
        return false;
      }
    },
    // 檢查登入者是否可開啟本頁面
    FnChkLoginMenu(menuPage) {
      try {
        if (!_.isString(menuPage)) {
          menuPage = this.VarMenuPage;
        }
        let chk = _.includes(this.LoginSetup.menus, menuPage);
        // 若是首頁無權限, 則自動導向第一個 menu(避免首頁無權限時, 登入後又一直跳回首頁)
        if (
          !chk &&
          menuPage.toLowerCase() == "index" &&
          !_.isEmpty(this.LoginSetup.menus)
        ) {
          // 檢查 this.LoginSetup.menus[0] 結尾是否有 .php
          if (!this.LoginSetup.menus[0].toLowerCase().endsWith(".php")) {
            this.FnPageSwitch(this.LoginSetup.menus[0] + ".php");
          } else {
            this.FnPageSwitch(this.LoginSetup.menus[0]);
          }
          return true;
        }
        return chk;
      } catch (e) {
        console.log("FnChkLoginMenu() error => " + JSON.stringify(e));
        return false;
      }
    },
    FnPadLeft(str, lenght, word) {
      // 左補0
      if (_.isUndefined(word)) {
        word = "0";
      }
      if (str.length >= lenght) {
        return str;
      } else {
        return this.FnPadLeft(word + str, lenght);
      }
    },
    FnPadRight(str, lenght, word) {
      // 右補0
      if (_.isUndefined(word)) {
        word = "0";
      }
      if (str.length >= lenght) {
        return str;
      } else {
        return this.FnPadRight(str + word, lenght);
      }
    },
    FnFormatNumber(num, decimalPlaces) {
      // 數字格式化成有千分位與小數點的字串
      // 轉換成數字型態
      num = Number(num);

      // 確認是否有小數點位數，預設為2位
      decimalPlaces = typeof decimalPlaces === "number" ? decimalPlaces : 2;

      // 取得整數部分
      var integerPart = Math.floor(num);

      // 取得小數部分，將小數點後的數字四捨五入到指定位數
      var decimalPart = (num - integerPart).toFixed(decimalPlaces).slice(2);

      // 將整數部分加上千分位逗號
      var formattedIntegerPart = integerPart.toLocaleString();

      // 如果沒有小數點，就補上指定位數的0
      if (decimalPlaces > 0 && decimalPart.length < decimalPlaces) {
        decimalPart =
          decimalPart + "0".repeat(decimalPlaces - decimalPart.length);
      }

      // 回傳格式化後的字串
      return (
        formattedIntegerPart + (decimalPlaces > 0 ? "." + decimalPart : "")
      );
    },
    FnRoundToDecimal(num, decimalPlaces) {
      // 四捨五入至指定的小數位
      // 轉換成數字型態
      num = Number(num);
      // 確認是否有小數點位數，預設為2位
      decimalPlaces = typeof decimalPlaces === "number" ? decimalPlaces : 2;
      var factor = Math.pow(10, decimalPlaces);
      var roundedNum = Math.round(num * factor) / factor;
      return roundedNum;
    },
    // 取得 url param 存成 session storage 的值
    // 沒有為 null 值
    /*
      usage:
      stn () {
        return this.FnGetUrlParamStorage("stn");
      }
    */
    FnGetUrlParamStorage(p, isSys) {
      // console.log(typeof isSys)
      let namePrefix = "$$url_param_";
      if (isSys) {
        namePrefix += "$$"; // 系統用的會再加 $$ 避免與後續專案使用名稱衝突
      }
      let uObj = new URL(location.href);
      let pVal = uObj.searchParams.get(p);
      if (pVal != null) {
        // 若有url param 則更新 session storage
        this.$q.sessionStorage.set(namePrefix + p, pVal);
      }
      return this.$q.sessionStorage.get.item(namePrefix + p);
    },
    // 仍會嚐試抓 url param, 沒有才寫預設值
    FnSetUrlParamStorage(p, defaultVal, isSys) {
      console.log(typeof isSys);
      let namePrefix = "$$url_param_";
      if (isSys) {
        namePrefix += "$$"; // 系統用的會再加 $$ 避免與後續專案使用名稱衝突
      }
      let uObj = new URL(location.href);
      let pVal = uObj.searchParams.get(p);
      if (pVal != null) {
        // 若有url param 則更新 session storage
        this.$q.sessionStorage.set(namePrefix + p, pVal);
      } else {
        this.$q.sessionStorage.set(namePrefix + p, defaultVal);
      }
      return this.$q.sessionStorage.get.item(namePrefix + p);
    },
    // 刪除 url param 存成 session storage 的值
    FnRemoveUrlParamStorage(p, isSys) {
      let namePrefix = "$$url_param_";
      if (isSys) {
        namePrefix += "$$"; // 系統用的會再加 $$ 避免與後續專案使用名稱衝突
      }
      return this.$q.sessionStorage.remove(namePrefix + p);
    },
  },
};
