var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
    "alarm-dispatch-form": httpVueLoader(
      "components/page/alarm_dispatch/alarm_dispatch_form.vue"
    ),
  },
  data() {
    return {
      VarMenuPage: "cashier_alarm_list",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      search: {
        start_date: moment().format("YYYY/MM/DD"),
        end_date: moment().format("YYYY/MM/DD"),
        store: "1",
      },
    };
  },
  computed: {
    columns() {
      // 為了配合多國語系, columns 需使用 computed
      return [
        {
          name: "store",
          required: true,
          label: this.$t("page.cashier_alarm_list.columns.store"),
          align: "left",
          field: "store_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "alarm_time",
          required: true,
          label: this.$t("page.cashier_alarm_list.columns.alarm_time"),
          align: "left",
          field: "alarm_time",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD HH:mm:ss");
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "alarm_type",
          required: true,
          label: this.$t("page.cashier_alarm_list.columns.alarm_type"),
          align: "left",
          field: "alarm_type",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "alarm_code",
          required: true,
          label: this.$t("page.cashier_alarm_list.columns.alarm_code"),
          align: "left",
          field: "alarm_code",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "alarm_message",
          required: true,
          label: this.$t("page.cashier_alarm_list.columns.alarm_message"),
          align: "left",
          field: "alarm_message",
          sortable: true,
          $$is_num_format: false,

          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searchList();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searchList() {
      let that = this;
      var params = {
        Action: "AlarmList",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    modalClose() {
      this.isModalOpen = false;
    },
  },
};
