var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
    "alarm-dispatch-form": httpVueLoader(
      "components/page/alarm_dispatch/alarm_dispatch_form.vue"
    ),
  },
  data() {
    return {
      VarMenuPage: "cashier_manage",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      search: {
        start_date: moment().format("YYYY/MM/DD"),
        end_date: moment().format("YYYY/MM/DD"),
        store: "1",
      },
      cashier_info: {
        show: false, //編輯門市版面顯示
        show_edit_btn: false, // 編輯門市按鈕

        edit_user_disable: false, // 編輯那些資料不能更新設定
        cashier_id: null, // 門市ID
        cashier_name: null, // 門市名稱
      },
    };
  },
  computed: {
    columns() {
      let arr = [];
      // 為了配合多國語系, columns 需使用 computed
      if (this.$root.FnChkPageFunction("otp_show")) {
        arr = [
          {
            name: "cashier_id",
            required: true,
            label: this.$t("page.cashier_manage.columns.cashier_id"),
            align: "left",
            field: "cashier_id",
            sortable: true,
            $$is_num_format: false,
            $$data_style: "font-size: 14px; padding: 6px;",
            style: "font-size: 14px; padding: 6px;",
          },
          {
            name: "cashier_name",
            required: true,
            label: this.$t("page.cashier_manage.columns.cashier_name"),
            align: "left",
            field: "cashier_name",
            sortable: true,
            $$is_num_format: false,
            $$data_style: "font-size: 14px; padding: 6px;",
            style: "font-size: 14px; padding: 6px;",
          },
          {
            name: "store",
            required: true,
            label: this.$t("page.cashier_manage.columns.store"),
            align: "left",
            field: "store_name",
            sortable: true,
            $$is_num_format: false,
            $$data_style: "font-size: 14px; padding: 6px;",
            style: "font-size: 14px; padding: 6px;",
          },
          {
            name: "store_otp",
            required: true,
            label: this.$t("page.cashier_manage.columns.store_otp"),
            align: "left",
            field: "store_otp",
            sortable: true,
            $$is_num_format: false,
            $$data_style: "font-size: 14px; padding: 6px;",
            style: "font-size: 14px; padding: 6px;",
          },
          {
            name: "update_at",
            required: true,
            label: this.$t("page.cashier_manage.columns.update_time"),
            align: "left",
            field: "update_at",
            sortable: true,
            $$is_num_format: false,
            format: function (data) {
              var dt = moment(data).format("YYYY-MM-DD HH:mm:ss");
              return dt;
            },
            $$data_style: "font-size: 14px; padding: 6px;",
            style: "font-size: 14px; padding: 6px;",
          },
        ];
      } else {
        arr = [
          {
            name: "cashier_id",
            required: true,
            label: this.$t("page.cashier_manage.columns.cashier_id"),
            align: "left",
            field: "cashier_id",
            sortable: true,
            $$is_num_format: false,
            $$data_style: "font-size: 14px; padding: 6px;",
            style: "font-size: 14px; padding: 6px;",
          },
          {
            name: "cashier_name",
            required: true,
            label: this.$t("page.cashier_manage.columns.cashier_name"),
            align: "left",
            field: "cashier_name",
            sortable: true,
            $$is_num_format: false,
            $$data_style: "font-size: 14px; padding: 6px;",
            style: "font-size: 14px; padding: 6px;",
          },
          {
            name: "store",
            required: true,
            label: this.$t("page.cashier_manage.columns.store"),
            align: "left",
            field: "store_name",
            sortable: true,
            $$is_num_format: false,
            $$data_style: "font-size: 14px; padding: 6px;",
            style: "font-size: 14px; padding: 6px;",
          },
          {
            name: "update_at",
            required: true,
            label: this.$t("page.cashier_manage.columns.update_time"),
            align: "left",
            field: "update_at",
            sortable: true,
            $$is_num_format: false,
            format: function (data) {
              var dt = moment(data).format("YYYY-MM-DD HH:mm:ss");
              return dt;
            },
            $$data_style: "font-size: 14px; padding: 6px;",
            style: "font-size: 14px; padding: 6px;",
          },
        ];
      }
      return arr;
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //設定功能開啟與否判斷
    setting_cheak() {
      return this.$root.FnChkPageFunction("setting");
    },
    // 異常訊息
    message_alart() {
      return [
        {
          label: "操作失敗",
          value: this.$t("page.cashier_manage.message.false"),
        },
        {
          label: "新增成功",
          value: this.$t("page.cashier_manage.message.create"),
        },
        {
          label: "新增失敗",
          value: this.$t("page.cashier_manage.message.create_error"),
        },
        {
          label: "更新成功",
          value: this.$t("page.cashier_manage.message.update"),
        },
        {
          label: "更新失敗",
          value: this.$t("page.cashier_manage.message.update_error"),
        },
        {
          label: "未輸入機器名稱",
          value: this.$t("page.cashier_manage.message.no_cashier_name"),
        },
      ];
    },
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      that.$q.loading.show();
      var params = {
        Action: "CashierList",
        Datas: that.search,
      };
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          console.log(err);
          that.$q.loading.hide();
        });
    },
    modalClose() {
      this.isModalOpen = false;
    },
    //	關閉設定畫面
    cancel_cashier_info() {
      this.cashier_info["show"] = false;
    },
    //	開啟新增/設定畫面
    async open_cashier_info(type, rowData = undefined) {
      this.$q.loading.show();
      this.$data.cashier_info = this.$options.data().cashier_info;
      if (type == "add") {
        this.cashier_info["show"] = true;
        this.cashier_info["show_add_btn"] = true;
      } else {
        let that = this;
        let param = {
          Action: "EditCashierInfo",
          Datas: {
            cashier: rowData.cashier_id,
          },
        };
        await that
          .FnWebAPIGet(param)
          .then(function (res) {
            var cashier_data = res.data.data;
            if (res.data.result) {
              that.cashier_info["cashier_id"] = cashier_data["cashier_id"];
              that.cashier_info["cashier_name"] = cashier_data["cashier_name"];
              that.cashier_info["show"] = true;
              that.cashier_info["show_edit_btn"] = true;
            } else {
              that.FnNotify(that.message_alart[0]["value"], "error");
              that.searsh_list();
            }
            that.$q.loading.hide();
          })
          .catch(async function (err) {
            that.$q.loading.hide();
            console.log(err);
          });
      }
    },
    //	更新
    save_cashier_info() {
      let that = this;
      that.$q.loading.show();
      //	機台名稱確認
      if (
        that.cashier_info["cashier_name"] == null ||
        that.cashier_info["cashier_name"] == ""
      ) {
        that.FnNotify(that.message_alart[5]["value"], "error");
        that.$q.loading.hide();
        return;
      }
      var param = {
        Action: "UpdateCashierInfo",
        Datas: {
          cashier: that.cashier_info.cashier_id,
          cashier_name: that.cashier_info.cashier_name,
        },
      };
      that
        .FnWebAPIPost(param)
        .then(function (res) {
          if (res.data.result) {
            that.FnNotify(that.message_alart[3]["value"], "success");
            that.searsh_list();
            that.cashier_info["show"] = false;
            that.$q.loading.hide();
          } else {
            that.FnNotify(that.message_alart[4]["value"], "error");
            that.searsh_list();
            that.cashier_info["show"] = true;
            that.$q.loading.hide();
          }
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
