var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_daily_cash_list",
      VarMenu: "shopee",
      tableData: [],
      isModalOpen: false,
      store: [],
      search: {
        store: "1",
        start_date: moment().format("YYYY/MM/DD"),
        end_date: moment().format("YYYY/MM/DD"),
      },
      excel_name: "StoreCashDailyInfo",
    };
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "statistics_date",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.statistics_date"),
          align: "left",
          field: "statistics_date",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 0,
          style: "font-size: 12px;",
        },
        {
          name: "store_id",
          label: this.$t("page.store_daily_cash_list.columns.store_id"),
          field: "store_id",
          $$only_excel: true,
          $$is_num_format: false,
          $$excel_index: 1,
        },
        {
          name: "store_name",
          label: this.$t("page.store_daily_cash_list.columns.store_name"),
          field: "store_name",
          $$only_excel: true,
          $$is_num_format: false,
          $$excel_index: 2,
        },
        {
          name: "cashier_name",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.cashier_name"),
          align: "left",
          field: "cashier_name",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 3,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_amount",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_amount"),
          align: "left",
          field: "total_amount",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 4,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_500",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_500"),
          align: "left",
          field: "total_500",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 5,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_100",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_100"),
          align: "left",
          field: "total_100",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 6,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_50",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_50"),
          align: "left",
          field: "total_50",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 7,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_10",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_10"),
          align: "left",
          field: "total_10",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 8,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_5",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_5"),
          align: "left",
          field: "total_5",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 9,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_1",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_1"),
          align: "left",
          field: "total_1",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 10,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_cash_amount",
          required: true,
          label: this.$t(
            "page.store_daily_cash_list.columns.total_cash_amount"
          ),
          align: "left",
          field: "total_cash_amount",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 11,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_cash_count",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_cash_count"),
          align: "left",
          field: "total_cash_count",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 12,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_coin_amount",
          required: true,
          label: this.$t(
            "page.store_daily_cash_list.columns.total_coin_amount"
          ),
          align: "left",
          field: "total_coin_amount",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 13,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_coin_count",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_coin_count"),
          align: "left",
          field: "total_coin_count",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 14,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_1000_in",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_1000_in"),
          align: "left",
          field: "total_1000_in",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 15,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_500_in",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_500_in"),
          align: "left",
          field: "total_500_in",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 16,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_100_in",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_100_in"),
          align: "left",
          field: "total_100_in",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 17,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_500_out",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_500_out"),
          align: "left",
          field: "total_500_out",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 18,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_100_out",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.total_100_out"),
          align: "left",
          field: "total_100_out",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 19,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cycle_rate",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.cycle_rate"),
          align: "left",
          field: "cycle_rate",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 20,
          format: function (data) {
            var dt = "";
            if (data > 100) {
              dt = vm.$t(
                "page.store_daily_cash_list.table_data.over_cycle_rate"
              );
            } else {
              dt = data + "%";
            }
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "reject_rate",
          required: true,
          label: this.$t("page.store_daily_cash_list.columns.reject_rate"),
          align: "left",
          field: "reject_rate",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 21,
          format: function (data) {
            var dt = data + "%";
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //excel 報表匯出 名稱定義
    excel_name_str() {
      let res = "";
      let store = "";
      let that = this;
      if (this.search.store != 0) {
        this.store.forEach(el => {
          if (el.value == that.search.store) {
            store = `_${el.label}`;
          }
        });
      }
      res = `${this.excel_name}ExportExcel${store}`;
      return res;
    }
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      var params = {
        Action: "DailyCashList",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
