<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	/**
	 * Leo
	 * 取得門市現金警戒設定
	 * @param start_date, end_date, store
	 * @return list[]
	 */
	public function SelectCashWarnList($params)
	{


		$a_where_arr = []; //sql條件陣列 
		$a_where_arr_val = [];
		$s_where_arr = ""; //sql條件字串，用$a_where_arr條件陣列轉換而來

		// 門市判斷條件
		if ($params['store'] != 0) {
			$a_where_arr[] = "_s.store_id = :store";
			$a_where_arr_val["store"] = $params['store'];
		}

		//門市查詢控制項 store_ctrl 0:只顯示營運中門市 1:顯示全門市
		if ($this->store_ctrl == 0) {
			$a_where_arr[] = " _s.store_state = 1 ";
		}

		//sql條件陣列轉換
		if (!empty($a_where_arr)) {
			$s_where_arr = " WHERE " . implode(" AND ", $a_where_arr);
		}
		//拼接sql字串
		$sql = sprintf(
			"SELECT 
				_s.store_id,
				_s.store_name,
				_s.cash_warning_level,
				_s.cash_stop_level,
				_s.cash_overflow_warning_level,
				_s.cash_overflow_stop_level,
				_s.coin_warning_water_level,
				_s.coin_stop_water_level,
				_s.coin_low_warning_water_level,
				_s.coin_low_stop_water_level,
				_s.coin_overflow_warning_level,
				_s.coin_overflow_stop_level
			FROM 
				[%s].[dbo].[store] AS _s
			%s
			",
			$this->database_trend,
			$s_where_arr
		);
		//準備執行sql
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute($a_where_arr_val);
		$a_store_data = $sth->fetchAll(PDO::FETCH_ASSOC);
		return $a_store_data;
	}

	/**
	 * Leo
	 * 編輯門市現金警戒設定
	 * @param store_id
	 * @return list[]
	 */
	public function SelectEditCashWarn($params)
	{

		//拼接sql字串
		$sql = sprintf(
			"SELECT 
				_s.store_id,
				_s.store_name,
				_s.cash_warning_level,
				_s.cash_stop_level,
				_s.cash_overflow_warning_level,
				_s.cash_overflow_stop_level,
				_s.coin_warning_water_level,
				_s.coin_stop_water_level,
				_s.coin_low_warning_water_level,
				_s.coin_low_stop_water_level,
				_s.coin_overflow_warning_level,
				_s.coin_overflow_stop_level,
				_s.petty_cash_500,
				_s.petty_cash_100,
				_s.petty_cash_50,
				_s.petty_cash_10,
				_s.petty_cash_5,
				_s.petty_cash_1
			FROM 
				[%s].[dbo].[store] AS _s
			WHERE
				_s.store_id = :store_id
			",
			$this->database_trend
		);
		//準備執行sql
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			"store_id" => $params["store_id"]
		]);
		$row = $sth->fetch(PDO::FETCH_ASSOC);
		$a_store_data = $row;
		return $a_store_data;
	}

	/**
	 * Leo
	 * 更新門市現金警戒設定
	 */
	public function ChangeUpdateCashWarn($params)
	{
		//門市id可能為多個 方便一次更新多門市 格式如下 111,123,151 已,區分
		$s_store_id_list = (string) $params["store_id"];
		//發鈔錢箱警告水位 (低水位判斷)
		$f_cash_warning_level = (int) $params["cash_warning_level"];
		//發鈔錢箱即停水位 (低水位判斷)
		$f_cash_stop_level = (int) $params["cash_stop_level"];
		//鈔票錢箱警告水位 (高水位判斷)
		$f_cash_overflow_warning_level = (int) $params["cash_overflow_warning_level"];
		//鈔票錢箱停止水位 (高水位判斷)
		$f_cash_overflow_stop_level = (int) $params["cash_overflow_stop_level"];
		//硬幣警告水位 (低水位判斷)
		$f_coin_low_warning_water_level = (float) $params["coin_low_warning_water_level"];
		//硬幣停止水位 (低水位判斷)
		$f_coin_low_stop_water_level = (float) $params["coin_low_stop_water_level"];
		//溢幣區(硬幣)警告水位，與硬幣循環機共用高水位判斷數值 (高水位判斷)
		$f_coin_overflow_warning_level = (int) $params["coin_overflow_warning_level"];
		//硬幣警告水位 (高水位判斷)
		$f_coin_warning_water_level = $f_coin_overflow_warning_level;
		//溢幣區(硬幣)停止水位，與硬幣循環機共用高水位判斷數值 (高水位判斷)
		$f_coin_overflow_stop_level = (int) $params["coin_overflow_stop_level"];
		//硬幣停止水位 (高水位判斷)
		$f_coin_stop_water_level = $f_coin_overflow_stop_level;

		if ($s_store_id_list == "") {
			throw new Exception("store 參數錯誤");
		}
		if ($f_cash_warning_level < 1 || $f_cash_warning_level > 75) {
			throw new Exception("cash_warning_level 參數錯誤");
		}
		if ($f_cash_stop_level < 1 || $f_cash_stop_level > 75) {
			throw new Exception("cash_stop_level 參數錯誤");
		}
		if ($f_cash_overflow_warning_level < 85 || $f_cash_overflow_warning_level > 100) {
			throw new Exception("cash_overflow_warning_level 參數錯誤");
		}
		if ($f_cash_overflow_stop_level < 85 || $f_cash_overflow_stop_level > 100) {
			throw new Exception("cash_overflow_stop_level 參數錯誤");
		}
		if ($f_coin_low_warning_water_level < 1 || $f_coin_low_warning_water_level > 75) {
			throw new Exception("coin_low_warning_water_level 參數錯誤");
		}
		if ($f_coin_low_stop_water_level < 1 || $f_coin_low_stop_water_level > 75) {
			throw new Exception("coin_low_stop_water_level 參數錯誤");
		}
		if ($f_coin_overflow_warning_level < 85 || $f_coin_overflow_warning_level > 100) {
			throw new Exception("coin_overflow_warning_level 參數錯誤");
		}
		if ($f_coin_overflow_stop_level < 85 || $f_coin_overflow_stop_level > 100) {
			throw new Exception("coin_overflow_stop_level 參數錯誤");
		}

		//拼接sql字串
		try {
			$sql = sprintf(
				"UPDATE [%s].[dbo].[store] 
				SET 
					[cash_warning_level] = :cash_warning_level,
					[cash_stop_level] = :cash_stop_level,
					[cash_overflow_warning_level] = :cash_overflow_warning_level,
					[cash_overflow_stop_level] = :cash_overflow_stop_level,
					[coin_warning_water_level] = :coin_warning_water_level,
					[coin_stop_water_level] = :coin_stop_water_level,
					[coin_low_warning_water_level] = :coin_low_warning_water_level,
					[coin_low_stop_water_level] = :coin_low_stop_water_level,
					[coin_overflow_warning_level] = :coin_overflow_warning_level,
					[coin_overflow_stop_level] = :coin_overflow_stop_level
				WHERE
					[store_id] IN (%s);
				",
				$this->database_trend,
				$s_store_id_list
			);
			//準備執行sql
			$sth = $this->pdo_sql->prepare($sql);
			$sth->execute([
				"cash_warning_level" => $f_cash_warning_level,
				"cash_stop_level" => $f_cash_stop_level,
				"cash_overflow_warning_level" => $f_cash_overflow_warning_level,
				"cash_overflow_stop_level" => $f_cash_overflow_stop_level,
				"coin_warning_water_level" => $f_coin_warning_water_level,
				"coin_stop_water_level" => $f_coin_stop_water_level,
				"coin_low_warning_water_level" => $f_coin_low_warning_water_level,
				"coin_low_stop_water_level" => $f_coin_low_stop_water_level,
				"coin_overflow_warning_level" => $f_coin_overflow_warning_level,
				"coin_overflow_stop_level" => $f_coin_overflow_stop_level,
			]);
			if ($sth->rowCount() == 0) {
				throw new Exception("store資料表更新失敗");
			}
			return true;
		} catch (Exception $mes) {
			$this->pdo_sql->rollBack();
			return $mes->getMessage();
		}
	}
}
