var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_received_ledger_list",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      search: {
        store: "1",
        start_date: moment().format("YYYY/MM/DD"),
        end_date: moment().format("YYYY/MM/DD"),
      },
      excel_name: "StoreCollection",
    };
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "received_date",
          required: true,
          label: this.$t(
            "page.store_received_ledger_list.columns.received_date"
          ),
          align: "left",
          field: "received_date",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD");
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 0,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "received_start_time",
          required: true,
          label: this.$t(
            "page.store_received_ledger_list.columns.received_start_time"
          ),
          align: "left",
          field: "received_start_time",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 3,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "received_end_time",
          required: true,
          label: this.$t(
            "page.store_received_ledger_list.columns.received_end_time"
          ),
          align: "left",
          field: "received_end_time",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 4,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "received_ledger_id",
          required: true,
          label: this.$t(
            "page.store_received_ledger_list.columns.received_ledger_id"
          ),
          align: "left",
          field: "received_ledger_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 2,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_id",
          required: true,
          label: this.$t("page.store_received_ledger_list.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 5,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_amount",
          required: true,
          label: this.$t(
            "page.store_received_ledger_list.columns.total_amount"
          ),
          align: "left",
          field: "total_amount",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 7,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "logistics_amount_total",
          required: true,
          label: this.$t(
            "page.store_received_ledger_list.columns.logistics_amount_total"
          ),
          align: "left",
          field: "logistics_amount_total",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 8,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "commodity_amount_total",
          required: true,
          label: this.$t(
            "page.store_received_ledger_list.columns.commodity_amount_total"
          ),
          align: "left",
          field: "commodity_amount_total",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          $$excel_index: 9,
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cashier_id",
          label: this.$t(
            "page.store_received_ledger_list.columns.cashier_id"
          ),
          field: "cashier_id",
          $$is_num_format: false,
          $$users_setting_is_show: false,
          $$only_excel: true,
          $$excel_index: 1
        },
        {
          name: "store_name",
          label: this.$t(
            "page.store_received_ledger_list.columns.store_name"
          ),
          field: "store_name",
          $$is_num_format: false,
          $$users_setting_is_show: false,
          $$only_excel: true,
          $$excel_index: 6,
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //excel 報表匯出 名稱定義
    excel_name_str() {
      let res = "";
      let store = "";
      let that = this;
      if (this.search.store != 0) {
        this.store.forEach(el => {
          if (el.value == that.search.store) {
            store = `_${el.label}`;
          }
        });
      }
      res = `${this.excel_name}ExportExcel${store}`;
      return res;
    }
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      var params = {
        Action: "ReceivedLedgerList",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
