<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
  // 引用 head.inc
  include_once "html_head.inc";
  ?>
</head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    // include_once "html_menu.inc";
    include_once "html_layout_header.inc";
    ?>
    <!-- 內容區域 //-->
    <data-table :show-search-field="true" :show-search-panel="true" :columns="columns" :data="tableData" row-key="no" @search-ok="searsh_list()">
      <template v-slot:page-sticky v-if="add_cheak">
        <q-btn round color="primary" @click.native="open_store_info('add')" icon="add"></q-btn>
      </template>
      <template v-slot:search-form>
        <div>
          <div class="w3-row-padding">
            <div class="w3-col l4 s6" style="max-width:300px">
              <q-select v-model="search.store" :stack-label="$t('page.store_list.search.store')" :options="store" filter />
            </div>
          </div>
        </div>
      </template>

      <template v-slot:row-control="props" v-if="edit_cheak">
        <div class="row" :style="props.row_data.row.reset_ctrl? 'width: 180px;':''">
          <q-btn style="margin: 0px 10px;" v-if="true" color="primary" :label="$t('sys.setting')" @click.native="open_store_info('edit',props.row_data.row)"></q-btn>
          <q-btn style="margin: 0px 10px;" v-if="props.row_data.row.reset_ctrl" color="deep-orange" :label="'初始化'" @click.native="open_store_reset(props.row_data.row)"></q-btn>
        </div>
      </template>
    </data-table>
    <!-- /內容區域 //-->

    <template>
      <q-modal v-model="store_info['show']" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss :content-css="{minWidth: '20vw', maxHeight: '100vh'}">
        <div class="modal-title">
          <div v-if="store_info['show_add_btn']">
            {{ $t('page.store_list.store_info_block.add_title') }}
          </div>
          <div v-else="">
            {{ $t('page.store_list.store_info_block.edit_title') }}
          </div>
        </div>
        <div class="modal-scroll-box" style="padding:15px; font-weight: 700; font-size:16px;min-height:30vh">
          <div style="margin-top: 0px;">
            <label style="color:#979797;" v-text="$t('page.store_list.store_info_block.store_id')"></label>
            <a style="color:red" v-text="store_info['show_edit_btn'] == true ? '':'＊'"></a>
            <q-input v-model="store_info['store_id']" :readonly="store_info['show_edit_btn']"></q-input>
          </div>
          <div style="margin-top: 0px;">
            <label style="color:#979797;" v-text="$t('page.store_list.store_info_block.store_name')"></label>
            <a style="color:red" v-text="store_info['show_edit_btn'] == true ? '':'＊'"></a>
            <q-input v-model="store_info['store_name']"></q-input>
          </div>
          <div style="margin-top: 0px;">
            <label style="color:#979797;" v-text="$t('page.store_list.store_info_block.store_area')"></label>
            <a style="color:red" v-text="store_info['show_edit_btn'] == true ? '':'＊'"></a>
            <q-select v-model="store_info['store_area']" :options="store_area"></q-select>
          </div>
          <div style="margin-top: 0px;">
            <q-datetime v-model="store_info.store_open_at" type="date" :stack-label="$t('page.store_list.store_info_block.store_open_at')">
            </q-datetime>
          </div>
          <div style="margin-top: 0px;">
            <label style="color:#979797;" v-text="$t('page.store_list.store_info_block.store_state')"></label>
            <a style="color:red" v-text="store_info['show_edit_btn'] == true ? '':'＊'"></a>
            <q-select v-model="store_info['store_state']" :options="store_state"></q-select>
          </div>
        </div>
        <div style="display:flex; flex-grow: row; justify-content: center;margin: 20px;">
          <q-btn color="primary" :label="$t('sys.save')" class="btn-style2" @click="add_store()" v-if="store_info['show_add_btn']"></q-btn>
          <q-btn color="primary" :label="$t('sys.update')" class="btn-style2" @click="save_store_info()" v-if="store_info['show_edit_btn']"></q-btn>
          <q-btn :color="store_info['show_edit_btn'] == true ? 'secondary' : 'secondary'" :label="$t('sys.close')" class="btn-style2" @click="cancel_store_info()"></q-btn>
        </div>
      </q-modal>
    </template>
    <template>
      <q-modal v-model="reset_allowance_info['show']" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss :content-css="{minWidth: '10vw', maxHeight: '100vh'}">
        <div class="modal-title">
          <div>
            {{ $t('page.store_allowance_setting.edit_block.edit_title') }}
          </div>
        </div>
        <div class="modal-scroll-box" style="padding:15px; font-weight: 700; font-size:16px">
          <div v-if="reset_allowance_info['show_store_info']" class="row justify-around">
            <div class="col-5" style="margin: 10px;">
              <label v-text="'門市編號'"></label>
              <q-input v-model="reset_allowance_info['store_id']" :readonly="true"></q-input>
            </div>
            <div class="col-5" style="margin: 10px;">
              <label v-text="'門市名稱'"></label>
              <q-input v-model="reset_allowance_info['store_name']" :readonly="true"></q-input>
            </div>
          </div>
          <div class="row">
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_500')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{reset_allowance_info['cash_500_max']}}</span>
              <q-input v-model="reset_allowance_info['petty_cash_500']" min="0" :max="reset_allowance_info['cash_500_max']" type="number"></q-input>
            </div>
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_100')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{reset_allowance_info['cash_100_max']}}</span>
              <q-input v-model="reset_allowance_info['petty_cash_100']" min="0" :max="reset_allowance_info['cash_100_max']" type="number"></q-input>
            </div>
          </div>
          <div class="row">
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_50')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{reset_allowance_info['cash_50_max']}}</span>
              <q-input v-model="reset_allowance_info['petty_cash_50']" min="0" :max="reset_allowance_info['cash_50_max']" type="number"></q-input>
            </div>
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_10')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{reset_allowance_info['cash_10_max']}}</span>
              <q-input v-model="reset_allowance_info['petty_cash_10']" min="0" :max="reset_allowance_info['cash_10_max']" type="number"></q-input>
            </div>
          </div>
          <div class="row">
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_5')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{reset_allowance_info['cash_5_max']}}</span>
              <q-input v-model="reset_allowance_info['petty_cash_5']" min="0" :max="reset_allowance_info['cash_5_max']" type="number"></q-input>
            </div>
            <div style="margin: 10px;">
              <label style="color:#979797;" v-text="$t('page.store_allowance_setting.edit_block.petty_cash_1')"></label>
              <span class="leo-input-tips" style="color:red">{{$t('page.store_allowance_setting.edit_block.max_count')}} : {{reset_allowance_info['cash_1_max']}}</span>
              <q-input v-model="reset_allowance_info['petty_cash_1']" min="0" :max="reset_allowance_info['cash_1_max']" type="number"></q-input>
            </div>
          </div>
        </div>
        <div style="display:flex; flex-grow: row; justify-content: center;margin: 20px;">
          <q-btn color="primary" :label="$t('sys.update')" class="btn-style2" @click="save_store_reset()" v-if="reset_allowance_info['show_edit_btn']"></q-btn>
          <q-btn :color="reset_allowance_info['show_edit_btn'] == true ? 'secondary' : 'secondary'" :label="$t('sys.close')" class="btn-style2" @click="cancel_store_reset()"></q-btn>
        </div>
      </q-modal>
    </template>
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  // loading.inc
  include_once "html_loading.inc";
  ?>
</body>
<?php
$is_report_download = true;
// 引用 down.inc
include_once "html_down.php";
?>

</html>