<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
  // 引用 head.inc
  include_once "html_head.inc";
  ?>
</head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    // include_once "html_menu.inc";
    include_once "html_layout_header.inc";
    ?>
    <!-- 內容區域 //-->
    <data-table :show-search-field="true" :show-search-panel="true" :show-download-btn="export_cheak" :columns="columns" :excel_name="excel_name_str" :data="tableData" sort_by="transaction_end_time" row-key="no" @search-ok="searsh_list()">
      <template v-slot:page-sticky>
        <!-- <q-btn round color="primary" @click="console.log(list)" icon="info"></q-btn> -->
      </template>
      <template v-slot:search-panel-actions>
      </template>
      <template v-slot:search-form>
        <div>
          <div class="w3-row-padding row no-wrap">
            <div class="w3-col l4 s6" style="max-width:300px">
              <q-select v-model="search.store" :stack-label="$t('page.store_transaction_fail_list.search.store')" :options="store" filter />
            </div>
            <div class="w3-col l4 s6" style="max-width:200px">
              <div class="leo-datetime-lable">{{$t('page.store_transaction_fail_list.search.start_date')}}</div>
              <datetime v-model="search.start_date" :phrases="datetime_phrases" type="datetime" input-class="leo-datetime-input" format="yyyy/MM/dd HH:mm:ss">
              </datetime>
            </div>
            <div class="w3-col l4 s6" style="max-width:200px">
              <div class="leo-datetime-lable">{{$t('page.store_transaction_fail_list.search.end_date')}}</div>
              <datetime v-model="search.end_date" :phrases="datetime_phrases" type="datetime" input-class="leo-datetime-input" format="yyyy/MM/dd HH:mm:59">
              </datetime>
            </div>
          </div>
        </div>
      </template>
      <template v-slot:row-control="props">
        <q-btn v-if="true" color="primary" label="貨幣明細" @click.native="show_fail_detail(props.row_data.row)"></q-btn>
      </template>
    </data-table>
    <!-- /內容區域 //-->

    <template>
      <q-modal v-model="transaction_fail_info['show']" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss :content-css="{minWidth: '50vw', maxHeight: '100vh'}">
        <div class="modal-title">
          <div class="column">
            {{$t('page.store_transaction_fail_list.dailog.shopee_shipment_id')}}
            <span slot="subtitle">{{transaction_fail_info["shopee_shipment_id"]}}</span>
          </div>
          <div class="column">
            {{$t('page.store_transaction_fail_list.dailog.shopee_order_id')}}
            <span slot="subtitle">{{transaction_fail_info["shopee_order_id"]}}</span>
          </div>
        </div>
        <div class="row">
          <div class="column col-6 ">
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_1000_in')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_1000_in']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_500_in')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_500_in']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_100_in')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_100_in']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_50_in')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_50_in']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_10_in')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_10_in']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_5_in')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_5_in']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_1_in')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_1_in']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.sub_100_in')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['sub_100_in']" readonly align="center"></q-input>
              </div>
            </div>
          </div>
          <div class="column col-6 ">
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_500_out')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_500_out']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_100_out')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_100_out']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_50_out')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_50_out']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_10_out')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_10_out']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_5_out')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_5_out']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.cash_1_out')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['cash_1_out']" readonly align="center"></q-input>
              </div>
            </div>
            <div class="row items-center" align="center">
              <label class="col-6 q-ma-sm" v-text="$t('page.store_transaction_fail_list.dailog.sub_100_out')"></label>
              <div class="col-5">
                <q-input v-model="transaction_fail_info['sub_100_out']" readonly align="center"></q-input>
              </div>
            </div>
          </div>
        </div>
        <div style="display:flex; flex-grow: row; justify-content: center;margin: 20px;">
          <q-btn color="secondary" :label="$t('sys.close')" class="btn-style2" @click="close_fail_detail()"></q-btn>
        </div>
      </q-modal>
    </template>
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  // loading.inc
  include_once "html_loading.inc";
  ?>
</body>
<?php
$is_report_download = true;
// 引用 down.inc
include_once "html_down.php";
?>

</html>